/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "projects.h"
#include "utilities.h"
#include "projectutils.h"
#include "gwrappers.h"


Projects::Projects (const ustring & projectsdirectory)
{
  // Gets all projects.
  ReadDirectories rd (projectsdirectory, "", "");
  for (unsigned int i = 0; i < rd.directories.size (); i++)
    {
      ustring s = rd.directories[i];
      projects.push_back (s);
      directories.push_back (gw_build_filename (projectsdirectory, s));
    }
}


Projects::~Projects ()
{
}
