/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "utilities.h"
#include <libgen.h>
#include <glib.h>
#include <config.h>
#include "gwrappers.h"
#include "gtkwrappers.h"
#include "scripturechecksloadresults.h"


ScriptureChecksLoadResults::ScriptureChecksLoadResults (const ustring& filename)
{
  // Read the file.
  bool was_error = false;
  gchar *contents;
  gsize  length;
  GError *error;
  error = NULL;
  if (!g_file_get_contents (filename.c_str(), &contents, &length, &error)) {
    cerr << error->message << endl;
    g_error_free (error);
    was_error = true;
  }
  // If length is (about) zero, don't parse it, because it does not have data,
  // and parsing an empty file gives a segmentation error.
  if (length < 10)
    was_error = true;
  // Set up parser.
  GMarkupParseContext *context;
  GMarkupParser parser = {
    start_element_handler,
    end_element_handler,
    text_handler,
    passthrough_handler,
    error_handler
  };
  // Parse xml file.
  if (!was_error) {
    context = g_markup_parse_context_new (&parser, GMarkupParseFlags (0), gpointer (this), NULL);
    if (!g_markup_parse_context_parse (context, contents, length, NULL)) {
      g_markup_parse_context_free (context);
      was_error = true;
      cerr << error->message << endl;
    }
  }
  if (!was_error) {
    if (!g_markup_parse_context_end_parse (context, NULL)) {
      g_markup_parse_context_free (context);
      was_error = true;
      cerr << error->message << endl;
    }
  }
  if (!was_error)
    g_markup_parse_context_free (context);
  current_value.clear();
}


ScriptureChecksLoadResults::~ScriptureChecksLoadResults ()
{
}


void ScriptureChecksLoadResults::start_element_handler (GMarkupParseContext *context,
                                   const gchar         *element_name,
                                   const gchar        **attribute_names,
                                   const gchar        **attribute_values,
                                   gpointer             user_data,
                                   GError             **error)
{
  ((ScriptureChecksLoadResults *) user_data)->start_element_handler (element_name);
}


void ScriptureChecksLoadResults::end_element_handler (GMarkupParseContext *context,
                                 const gchar         *element_name,
                                 gpointer             user_data,
                                 GError             **error)
{
  ((ScriptureChecksLoadResults *) user_data)->end_element_handler (element_name);
}


void ScriptureChecksLoadResults::text_handler (GMarkupParseContext *context,
                          const gchar         *text,
                          gsize                text_len,
                          gpointer             user_data,
                          GError             **error)
{
  ((ScriptureChecksLoadResults *) user_data)->text_handler (text);
}



void ScriptureChecksLoadResults::passthrough_handler    (GMarkupParseContext *context,
                                    const gchar         *passthrough_text,
                                    gsize                text_len,
                                    gpointer             user_data,
                                    GError             **error)
{
}


void ScriptureChecksLoadResults::error_handler          (GMarkupParseContext *context,
                                    GError              *error,
                                    gpointer             user_data)
{
  cerr << error->message << endl;
}


void ScriptureChecksLoadResults::start_element_handler (const gchar *element_name)
/*
When we encounter a new element that starts data, this handler deals with that.
*/
{
  ustring element (element_name);
  if (element_name == "message") {
    book = "Unknown";
    chapter = "0";
    verse = "0";
  }
  current_value.clear();
}


void ScriptureChecksLoadResults::end_element_handler (const gchar *element_name)
/*
When we encounter an element that ends data, this handler deals with that.
*/
{
  ustring element (element_name);
  current_value = trim (current_value);
  if (element == "book") {
    book = current_value;
  } else if (element == "chapter") {
    chapter = current_value;
  } else if (element == "verse") {
    verse = current_value;
  } else if (element == "text") {
    text = current_value;
  } else if (element == "message") {
    references.push_back (book + " " + chapter + ":" + verse);
    comments.push_back (text);
  }
  current_value.clear();
}


void ScriptureChecksLoadResults::text_handler (const gchar *text)
/*
When we encounter the text inside an element, this handler deals with that.
*/
{
  current_value.append (text);
}
