/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "upgrade.h"
#include "stylesheetutils.h"
#include "projectutils.h"
#include "notes_utils.h"
#include "generalconfig.h"
#include "projectconfig.h"
#include "templates.h"
#include "xep.h"


void upgrade (bool gui)
{
  stylesheets_upgrade ();
  projects_initial_check (gui);
  notes_database_verify (gui);
  notes_categories_check ();
  upgrade_configuration ();
  vector <ustring> projects = projects_get_all ();
  for (unsigned int i = 0; i < projects.size(); i++) {
    upgrade_project_configuration (projects[i]);
  }
  check_templates (gui);
  xep_check ();
}
