/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _DIALOGMAIN_H
#define _DIALOGMAIN_H

#include <gtkmm.h>
#include <iostream>
#include <libintl.h>
#include "Book.h"
#include "GtkBookList.h"
#include "DialogAbout.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

#define DIALOG_MAIN_SUMMARY_LENGTH 150

class DialogMain : public Gtk::Window {
public:
  DialogMain();
  ~DialogMain();
  
  /* Triggered whenever the 'Add' button has been clicked. */
  SigC::Signal0<void> signal_button_add_clicked;
  /* Triggered whenever the 'Delete' button has been clicked. */
  SigC::Signal0<void> signal_button_delete_clicked;
  /* Triggered whenever the 'Show Details' button has been clicked. */
  SigC::Signal0<void> signal_button_details_clicked;
  
  /* Update the preview informations according to the given book. */
  void update_preview(Book* book);
  
  GtkBookList   booklist;
protected:
  /* Called, whenever the File/Quit item has been activated. */
  void on_file_quit_clicked(void);
  /* Called, whenever a View/Sort by... item has been activated. */
  void on_view_sortorder_clicked(int column);
  /* Called, whenever the Help/About item has been activated. */
  void on_help_about_clicked(void);
  /* Called, whenever the booklist selection was changed. */
  void on_booklist_selection_changed(Book* book);
  /* Called, whenever the booklist sort order was changed. */
  void on_booklist_sorting_changed(void);
  /* Called, whenever the booklist content was changed. */
  void on_booklist_changed(void);
  
  DialogAbout   aboutbox;
  bool          lock_events;
  Gtk::VBox     vbox_main;
  
  // The menu.
  Gtk::MenuBar  menubar;
  Gtk::Menu     menu_file;
  Gtk::Menu                        menu_view;
  Gtk::RadioButtonGroup            menu_view_group_sort;
  Gtk::Menu_Helpers::RadioMenuElem menu_view_elem_sort_author;
  Gtk::Menu_Helpers::RadioMenuElem menu_view_elem_sort_title;
  Gtk::Menu_Helpers::RadioMenuElem menu_view_elem_sort_category;
  Gtk::Menu_Helpers::RadioMenuElem menu_view_elem_sort_readdate;
  Gtk::Menu_Helpers::RadioMenuElem menu_view_elem_sort_rating;
  Gtk::Menu     menu_help;
  
  // The button area.
  Gtk::HBox     hbox_buttons;
  Gtk::Fixed    fixed_buttons;
  
  Gtk::Button   button_add;
  Gtk::HBox     hbox_button_add;
  Gtk::Image    image_button_add;
  Gtk::Label    label_button_add;
  
  Gtk::Button   button_delete;
  Gtk::HBox     hbox_button_delete;
  Gtk::Image    image_button_delete;
  Gtk::Label    label_button_delete;
  
  Gtk::Button   button_details;
  Gtk::HBox     hbox_button_details;
  Gtk::Image    image_button_details;
  Gtk::Label    label_button_details;
  
  // The preview area.
  Gtk::Table    table_preview;
  Gtk::Label    label_expander;
  Gtk::Label    label_title;
  Gtk::Label    label_author;
  Gtk::Fixed    fixed_preview;
  Gtk::Label    label_summary;
  Gtk::Label    label_isbn;
  
  // The book list.
  Gtk::Label    label_booklist;
  Gtk::ScrolledWindow scroll_booklist;
};

#endif /* _DIALOGMAIN_H */
