import tempfile,os.path,sys
import wx
import BIB,dbBibSQLite

def convertDB():
    """ We convert SQLite db from bibus 1.3 or 1.4 to 1.5 by adding the table table_modif and/or table_file"""
    def fixPath(url):
        if not url.startswith("file://"): return None
        url = url[7:]
        if url.startswith("/$FILES"): url = url[1:]
        if sys.platform == 'win32':
            return os.path.normpath( url.lstrip('/') )
        return os.path.normpath(url)

    #
    db_old = dbBibSQLite.dbBib()
    db_old.selectTable()
    isDBok = True
    oldtables = db_old.getTables()
    for tab in (BIB.DB_TABLE_REF, BIB.DB_TABLE_KEY, BIB.DB_TABLE_LINK, BIB.DB_TABLE_QUERY, BIB.DB_TABLE_MODIF, BIB.DB_TABLE_FILE):
        if tab not in oldtables:
            isDBok = False
            break
    if isDBok: return    # All the tables are present, we can continue with the table
    
    # Otherwise we create a new clean db and we copy the data from the old to the new db
    # we create the database in the default location

    wx.MessageBox(_('Your database needs to be converted to the new format.\nThe original database file will not be changed, but a new copy will be created.\nThe conversion may take a while.'),_("Database conversion"),wx.OK)
    progress = wx.ProgressDialog(_("Database conversion"),\
        _("Conversion of your old SQLite database to the new bibus format. Please be patient."),\
        parent = None,
        style = wx.PD_AUTO_HIDE | wx.PD_APP_MODAL | wx.PD_SMOOTH | wx.PD_REMAINING_TIME )
        
    f = tempfile.NamedTemporaryFile('w+b',-1,'.sqlite','DB_', os.path.join( wx.StandardPaths.Get().GetUserDataDir(), "Databases") )
    BIB.SQLiteFile = f.name
    f.close()
    #
    db = dbBibSQLite.dbBib()
    db.createDatabase(BIB.SQLiteFile,BIB.DB_TABLE_REF,BIB.DB_TABLE_KEY,BIB.DB_TABLE_LINK,BIB.DB_TABLE_QUERY,BIB.DB_TABLE_MODIF,BIB.DB_TABLE_FILE)
    #
    refsId=[]
    tmprefs = db_old.getAllDatabase(collist=())
    refsId = [x[0] for x in tmprefs]
    progress.Update(10)
    # writing records
    if BIB.DB_TABLE_REF in oldtables:
        i = 0
        for refId in refsId:
            db.writeRef( db_old.getRef(refId,BIB.BIB_FIELDS)[0] )
            progress.Update(float(i)/len(refsId)*30+10)
            i+=1
    #progress.Update(25)
    # now we copy the keys
    if BIB.DB_TABLE_KEY in oldtables:
        for key in db_old.getAllKeys():
            db.dumpKey( key )
    progress.Update(40)
    # now the Links
    if BIB.DB_TABLE_LINK in oldtables:
        for link in db_old.getAllLinks():
            db.writeLink( link )
    progress.Update(55)
    # then the queries
    if BIB.DB_TABLE_QUERY in oldtables:
        for query in db_old.getAllQueries():
            db.dumpQuery( query )
    progress.Update(70)
    # now the modifs
    if BIB.DB_TABLE_MODIF in oldtables:
        for modif in db_old.getAllModifs():
            apply(db.resetCreator,modif)
    progress.Update(85)
    # and the files
    if BIB.DB_TABLE_FILE in oldtables:
        for filen in db_old.getAllFiles():
            db.setCreator( filen )
    else:
        # Table DB_TABLE_FILE appears with bibus 1.5.
        # Before, url handling was a mess and some paths were broken
        # We try to automatically fix the wrong paths
        for refId in refsId:
            nurl = fixPath( db_old.getRef(refId,('URL',))[0][0] )
            if nurl:
                db.modifyRef(('URL',),(nurl,),refId)
        
    progress.Update(100)
    progress.Destroy()
    # if default database is set in config DB_STARTUP=1, the new db won't be used at the next startup
    # we simply revert to the default setting, ie we open the last db.
    BIB.DB_STARTUP = 0
    #    
    wx.MessageBox(_('Your database has been converted to the new format.\nThe database is now located at\n"%s"')%f.name,_("Database conversion"),wx.OK)

