# Derived from cx_freeze default script for wxPython applications
#
# This script should not ne run directly but using the script build
# >> cd bibus
# >> C:\Python26\python.exe Freeze\setup.py build
#
# This is Windows only but could be adapted for linux but who minds about
# compiling python scritps under linux ???

import sys,os.path,shutil,gettext
gettext.install("dummy")	# just needed to import BIBUS_VERSION
from cx_Freeze import setup, Executable
from BIBbase import BIBUS_VERSION

# The following constants may have to be adjusted to your system paths
pythonpath = os.path.split(sys.executable)[0]			# 'C:\\Python26'
wxpython = os.path.join(pythonpath,"Lib","site-packages","wx-2.8-msw-unicode")
extraDLLs = ["sqlite3.dll"]

# Target directory for freezed executable
targetDir = os.path.abspath( os.path.join("Freeze","Freezed_Bibus") )
#targetDir = os.path.abspath("Freezed_Bibus")

# We remove the old Freezed_Bibus
shutil.rmtree(targetDir,True)

############################ Utility functions ################################
def getModules():
	"""Return a list of the modules dynamically loaded from Import/Export/Format directories
	Import/Export are now loaded dynamically in 1.5.0 and are not to be included
	"""
	
	modulesList = []
	# getting modules in Format
	for (dirpath, dirnames, filenames) in os.walk( os.path.join('..','Format') ):
		for filename in filenames:
			if filename.endswith('.py') and not filename.startswith('__'):
				tmp = os.path.join( dirpath,filename[:-3] )
				modulesList.append( '.'.join( tmp.split(os.sep)[1:] ) )

	# getting modules in Import
	#for filename in os.listdir( os.path.join('..','Import') ):
	#	if filename.endswith('.py') and not filename.startswith('__'):
	#		modulesList.append( '.'.join( ('Import',filename[:-3]) ))

	# getting modules in Export
	#for filename in os.listdir( os.path.join('..','Export') ):
	#	if filename.endswith('.py') and not filename.startswith('__'):
	#		modulesList.append( '.'.join( ('Export',filename[:-3]) ))

	return modulesList
	
def cleanCVS(directory):
	"""Remove recursively all the CVS directories in 'directory'"""
	if not os.path.isdir(directory): return
	for root,dirs,files in os.walk(directory):
		if os.path.split(root)[-1] == "CVS":
			shutil.rmtree(root,True)

############################ End of Utility functions ############################
bibusInitScript = os.path.abspath( os.path.join("Freeze","InitBibus.py") )
bibusIcon = os.path.abspath( os.path.join("Pixmaps","bibus.ico") )

buildOptions = dict(
        compressed = True,
        optimize = 2,
        init_script =  bibusInitScript,
        base = "Win32GUI",
        icon = bibusIcon,
        includes= ','.join(getModules()),
        build_exe = targetDir
        )

setup(
        name = "bibus",
        version = BIBUS_VERSION,
        description = "Bibus Bibliographic database",
        options = dict(build_exe = buildOptions),
        executables = [Executable("bibus.py")]
	)

############################ Additional files and directories #######################

# copying other required files
shutil.copy( "bibus.cfg" ,targetDir)
shutil.copy( "bibus.config" ,targetDir)
shutil.copy( "MySQL_Bibus.ini" ,targetDir)
shutil.copy( os.path.join("Freeze","bibus.exe.manifest") ,targetDir)

os.mkdir( os.path.join(targetDir,"StyleEditor") )
shutil.copy( os.path.join("StyleEditor","default_style") ,os.path.join(targetDir,"StyleEditor") )

# we need to copy the modules for the style editor even if we included them
shutil.copytree( "Format", os.path.join(targetDir,"Format") )

# we need pixmap for the icon in the executable
shutil.copytree( "Pixmaps", os.path.join(targetDir,"Pixmaps") )

shutil.copytree( "locale", os.path.join(targetDir,"locale") )

shutil.copytree( "db_models", os.path.join(targetDir,"db_models") )

shutil.copytree( "Docs", os.path.join(targetDir,"Docs") )

shutil.copytree( "Import", os.path.join(targetDir,"Import") )
shutil.copytree( "Export", os.path.join(targetDir,"Export") )

os.mkdir( os.path.join(targetDir,"Data") )
shutil.copy( os.path.join("Data","journals.csv"), os.path.join(targetDir,"Data") )

# we copy the files in extraDLLs
for f in extraDLLs:
	shutil.copy(os.path.join(pythonpath,"DLLs",f),targetDir)

# we copy the wxpython DLLs
for f in os.listdir(os.path.join(wxpython,'wx')):
	if os.path.splitext(f)[-1].upper() == ".DLL":
		shutil.copy(os.path.join(wxpython,'wx',f),targetDir)

# we remove the CVS directory that may have been copied
cleanCVS( targetDir )
