/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <kozo.h>

#include <kozo/kozo-db.h>
#include <kozo/kozo-entry.h>
#include <kozo/kozo-field.h>
#include <kozo/kozo-util.h>

#include <dbus/dbus-glib.h>

#include "bkl-internal-marshal.h"
#include "bkl-utils.h"

/* String lists are separated by 0x01 */
#define SEPARATOR 0x01
#define STRING_SEPARATOR "\x01"

char *
_bkl_string_array_to_string (GPtrArray *array)
{
    GString *builder;
    char *str;
    int i;

    if (array == NULL ||
        array->len == 0) {
        return g_strdup ("");
    }

    builder = g_string_new (array->pdata[0]);
    for (i = 1; i < array->len; i++) {
        g_string_append_c (builder, SEPARATOR);
        g_string_append (builder, array->pdata[i]);
    }

    str = builder->str;
    g_string_free (builder, FALSE);
    return str;
}

GPtrArray *
_bkl_string_to_string_array (const char *str)
{
    GPtrArray *array;
    char **vector;
    int i;

    if (str == NULL || *str == '\0') {
        return NULL;
    }

    vector = g_strsplit (str, STRING_SEPARATOR, 0);
    if (vector == NULL) {
        return NULL;
    }

    array = g_ptr_array_new ();
    for (i = 0; vector[i]; i++) {
        g_ptr_array_add (array, vector[i]);
    }

    g_free (vector);
    return array;
}

void
bkl_init (void)
{
    g_type_init ();

    kozo_init ();
    dbus_g_object_register_marshaller (bkl_internal_marshal_VOID__STRING_STRING,
                                       G_TYPE_NONE, G_TYPE_STRING,
                                       G_TYPE_STRING, G_TYPE_INVALID);
}

void
bkl_shutdown (void)
{
    kozo_shutdown ();
}
