/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <sys/types.h>
#include <unistd.h>

#include <glib.h>

#include <dbus/dbus-protocol.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-bindings.h>

#include "bkl-investigator.h"
#include "bkl-investigator-dbus.h"
#include "bkl-marshal.h"

enum {
    PROCESSING,
    COMPLETED,
    LAST_SIGNAL
};

G_DEFINE_TYPE (BklInvestigatorDBus, bkl_investigator_dbus, G_TYPE_OBJECT);

static guint32 signals[LAST_SIGNAL] = {0, };

static gboolean bkl_investigator_get_process_id (BklInvestigatorDBus *dbus,
                                                 int                 *OUT_pid,
                                                 GError             **error);
static gboolean bkl_investigator_investigate_uris (BklInvestigatorDBus *dbus,
                                                   const char          *IN_source,
                                                   const char         **IN_uris,
                                                   int                  IN_n_uris,
                                                   GError             **error);
static gboolean bkl_investigator_replace (BklInvestigatorDBus *dbus,
                                          GError             **error);
static gboolean bkl_investigator_cancel_source (BklInvestigatorDBus *dbus,
                                                const char          *IN_source,
                                                GError             **error);
static gboolean bkl_investigator_cancel_uris (BklInvestigatorDBus *dbus,
                                              const char         **IN_uris,
                                              GError             **error);
#include "bkl-investigator-glue.h"

static gboolean
bkl_investigator_get_process_id (BklInvestigatorDBus *dbus,
                                 int                 *OUT_pid,
                                 GError             **error)
{
    *OUT_pid = getpid ();
    return TRUE;
}

static gboolean
bkl_investigator_investigate_uris (BklInvestigatorDBus *dbus,
                                   const char          *IN_source,
                                   const char         **IN_uris,
                                   int                  IN_n_uris,
                                   GError             **error)
{
    bkl_investigator_add_uris (IN_source, IN_uris, IN_n_uris);
    return TRUE;
}

static gboolean
bkl_investigator_replace (BklInvestigatorDBus *dbus,
                          GError             **error)
{
    bkl_investigator_shutdown ();
    return TRUE;
}

static gboolean
bkl_investigator_cancel_source (BklInvestigatorDBus *dbus,
                                const char          *IN_source,
                                GError             **error)
{
    _bkl_investigator_cancel_source (IN_source);
    return TRUE;
}

static gboolean
bkl_investigator_cancel_uris (BklInvestigatorDBus *dbus,
                              const char         **IN_uris,
                              GError             **error)
{
    _bkl_investigator_cancel_uris (IN_uris);
    return TRUE;
}

static void
bkl_investigator_dbus_class_init (BklInvestigatorDBusClass *klass)
{
    dbus_g_object_type_install_info (G_TYPE_FROM_CLASS (klass),
                                     &dbus_glib_bkl_investigator_object_info);

    signals[PROCESSING] = g_signal_new ("processing",
                                        G_TYPE_FROM_CLASS (klass),
                                        G_SIGNAL_RUN_FIRST |
                                        G_SIGNAL_NO_RECURSE, 0,
                                        NULL, NULL,
                                        bkl_marshal_VOID__STRING_STRING,
                                        G_TYPE_NONE, 2,
                                        G_TYPE_STRING,
                                        G_TYPE_STRING);

    signals[COMPLETED] = g_signal_new ("uri_completed",
                                       G_TYPE_FROM_CLASS (klass),
                                       G_SIGNAL_RUN_FIRST |
                                       G_SIGNAL_NO_RECURSE, 0,
                                       NULL, NULL,
                                       bkl_marshal_VOID__STRING_STRING_POINTER,
                                       G_TYPE_NONE, 3,
                                       G_TYPE_STRING,
                                       G_TYPE_STRING,
                                       DBUS_TYPE_G_STRING_STRING_HASHTABLE);
}

static void
bkl_investigator_dbus_init (BklInvestigatorDBus *self)
{
}

BklInvestigatorDBus *
bkl_investigator_dbus_new (void)
{
    return g_object_new (BKL_TYPE_INVESTIGATOR_DBUS, NULL);
}

void
bkl_investigator_dbus_processing (BklInvestigatorDBus *dbus,
                                  const char          *source,
                                  const char          *uri)
{
    g_signal_emit (dbus, signals[PROCESSING], 0, source, uri);
}

void
bkl_investigator_dbus_completed (BklInvestigatorDBus *dbus,
                                 const char          *source,
                                 const char          *uri,
                                 GHashTable          *metadata)
{
    g_signal_emit (dbus, signals[COMPLETED], 0, source, uri, metadata);
}
