# -*- coding: utf-8 -*-
# Copyright 2009-2019 Joshua Bronson. All Rights Reserved.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

"""Define bidict package metadata."""


__version__ = '0.0.0.VERSION_NOT_FOUND'

# _version.py is generated by setuptools_scm (via its `write_to` param, see setup.py)
try:
    from ._version import version as __version__  # pylint: disable=unused-import
except (ImportError, ValueError, SystemError):  # pragma: no cover
    try:
        import pkg_resources
    except ImportError:
        pass
    else:
        try:
            __version__ = pkg_resources.get_distribution('bidict').version
        except pkg_resources.DistributionNotFound:
            pass

try:
    __version_info__ = tuple(int(p) if i < 3 else p for (i, p) in enumerate(__version__.split('.')))
except Exception:  # noqa: E722; pragma: no cover; pylint: disable=broad-except
    __vesion_info__ = (0, 0, 0, 'PARSE FAILURE: __version__=%s' % __version__)

__author__ = u'Joshua Bronson'
__maintainer__ = u'Joshua Bronson'
__copyright__ = u'Copyright 2019 Joshua Bronson'
__email__ = u'jab@math.brown.edu'

# See: ../docs/thanks.rst
__credits__ = [i.strip() for i in u"""
Joshua Bronson, Michael Arntzenius, Francis Carr, Gregory Ewing, Raymond Hettinger, Jozef Knaperek,
Daniel Pope, Terry Reedy, David Turner, Tom Viner
""".split(u',')]

__description__ = u'Efficient, Pythonic bidirectional map implementation and related functionality'
__keywords__ = 'dict dictionary mapping datastructure bimap bijection bijective ' \
    'injective inverse reverse bidirectional two-way 2-way'

__license__ = u'MPL 2.0'
__status__ = u'Beta'
__url__ = u'https://bidict.readthedocs.io'
