/*=====================================================================*/
/*    .../prgm/project/bigloo/api/fthread/src/Java/bglfmutex.java      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sat Mar  5 13:37:30 2005                          */
/*    Last change :  Wed Apr 13 15:56:11 2005 (serrano)                */
/*    Copyright   :  2005 Manuel Serrano                               */
/*    -------------------------------------------------------------    */
/*    Mutex implementation                                             */
/*=====================================================================*/

/*---------------------------------------------------------------------*/
/*    The package                                                      */
/*---------------------------------------------------------------------*/
package bigloo.fthread;
import java.lang.*;
import bigloo.*;

/*---------------------------------------------------------------------*/
/*    bglfmutex                                                        */
/*---------------------------------------------------------------------*/
public class bglfmutex extends bigloo.mutex {
   protected static void setup() {
      bigloo.mutex.amutex = new bglfmutex( bigloo.foreign.BUNSPEC );
   }

   private boolean locked = false;
   
   private Object specific;

   public bglfmutex( Object n ) {
      super(n);
   }

   protected bigloo.mutex create( Object name ) {
      return new bglfmutex(name);
   }

   public synchronized boolean acquire_lock() {
      try {
	 while( locked == true ) {
	    wait();
	 }
	 locked = true;
	 notify();
	 return true;
      } catch( Exception _ ) {
	 return false;
      }
   }

   public synchronized boolean release_lock() {
      locked = false;
      notify();
      return true;
   }

   public static Object SPECIFIC( Object m ) {
      if( m instanceof bglfmutex )
	 return ((bglfmutex) m).specific;
      else
	 return bigloo.foreign.BUNSPEC;
   }

   public static void SPECIFIC_SET( Object m, Object s ) {
      ((bglfmutex) m).specific = s;
   }

   public static Object state( Object m ) {
      return bigloo.foreign.string_to_symbol( "not-abandoned" );
   }
}
