/*=====================================================================*/
/*    .../prgm/project/bigloo/api/fthread/src/Posix/bglfthread.h       */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Feb 22 11:01:20 2002                          */
/*    Last change :  Tue Aug  9 06:20:52 2005 (serrano)                */
/*    Copyright   :  2002-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The C headers for Bigloo fair threads.                           */
/*=====================================================================*/
#include <pthread.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    bglfthread_t                                                     */
/*---------------------------------------------------------------------*/
typedef struct bglfthread {
   obj_t thunk;
   obj_t bglobj;
   obj_t name;
   bgldenv_t env;
   pthread_t pthread;
   pthread_mutex_t lock;
   pthread_cond_t cv;
   struct bglfthread *parent;
} *bglfthread_t;

/*---------------------------------------------------------------------*/
/*    bglfmutex_t                                                      */
/*---------------------------------------------------------------------*/
typedef struct bglfmutex {
   pthread_mutex_t pmutex;
   bglfthread_t thread;
   bool_t locked;
} *bglfmutex_t;

/*---------------------------------------------------------------------*/
/*    bglfcondvar_t                                                    */
/*---------------------------------------------------------------------*/
typedef struct bglfcondvar {
   pthread_cond_t pcondvar;
} *bglfcondvar_t;

/*---------------------------------------------------------------------*/
/*    Mutexes                                                          */
/*---------------------------------------------------------------------*/
#define BGLFTH_MUTEX_BGLPMUTEX( o ) \
   ((bglfmutex_t)((o)->mutex_t.mutex))
#define BGLFTH_MUTEX_PMUTEX( o ) \
   (&(BGLFTH_MUTEX_BGLPMUTEX( o )->pmutex))

/*---------------------------------------------------------------------*/
/*    Condition variables                                              */
/*---------------------------------------------------------------------*/
#define BGLFTH_CONDVAR_BGLPCONDVAR( o ) \
   ((bglfcondvar_t)((o)->condvar_t.condvar))
#define BGLFTH_CONDVAR_PCONDVAR( o ) \
   (&(BGLFTH_CONDVAR_BGLPCONDVAR( o )->pcondvar))

/*---------------------------------------------------------------------*/
/*    String buffers                                                   */
/*---------------------------------------------------------------------*/
#define BGL_STRING_REF( _s, _i ) ((_s)[ _i ])
#define BGL_STRING_SET( _s, _i, _v ) ((_s)[ _i ] = (_v))

/*---------------------------------------------------------------------*/
/*    Prototypes                                                       */
/*---------------------------------------------------------------------*/
extern bglfthread_t bglfth_thread_new( obj_t );
extern bglfthread_t bglfth_thread_new_with_name( obj_t, obj_t );
extern void bglfth_thread_start( bglfthread_t, obj_t );

extern void bglfth_thread_wait( bglfthread_t );
extern void bglfth_thread_switch( bglfthread_t, bglfthread_t );

extern void bglfth_thread_enter_scheduler( bglfthread_t );
extern void bglfth_thread_leave_scheduler( bglfthread_t );

extern obj_t bglfth_thread_id_set( bglfthread_t, obj_t );
extern obj_t bglfth_thread_id_get();
extern bglfthread_t bglfth_current_thread();

extern void bglfth_async_spawn( bglfthread_t, obj_t, obj_t );
extern void bglfth_async_synchronize( bglfthread_t );
extern void bglfth_async_asynchronize( bglfthread_t );
extern void bglfth_async_scheduler_wait( bglfthread_t );
extern void bglfth_async_scheduler_notify( bglfthread_t );

extern bool_t bglfth_mutex_lock( obj_t );
extern bool_t bglfth_mutex_unlock( obj_t );
extern void bgfpth_mutexes_unlock( bglfthread_t );

