/*=====================================================================*/
/*    serrano/prgm/project/bigloo/api/fthread/src/Posix/bglsetup.c     */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Thu Oct 21 15:57:25 2004                          */
/*    Last change :  Tue Aug  9 06:33:14 2005 (serrano)                */
/*    Copyright   :  2004-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The pthread setup                                                */
/*=====================================================================*/
#include <pthread.h>

#define GC_PRIVATE_H
#include <gc.h>
#include <bigloo.h>
#include <bglfthread.h>

/*---------------------------------------------------------------------*/
/*    imports                                                          */
/*---------------------------------------------------------------------*/
extern void bglfth_setup_mutex();
extern void bglfth_setup_condvar();
extern void bglfth_setup_thread();
extern void bglfth_setup_bmem();

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglfth_setup_gc ...                                              */
/*---------------------------------------------------------------------*/
void
bglfth_setup_gc() {
#if( BGL_GC == BGL_BOEHM_GC && BGL_GC_HAVE_BLOCKING )
   extern void GC_start_blocking();
   extern void GC_end_blocking();

   bgl_gc_start_blocking = &GC_start_blocking;
   bgl_gc_stop_blocking = &GC_end_blocking;
#endif
   
   GC_init();
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglfth_setup ...                                                 */
/*---------------------------------------------------------------------*/
BGL_EXPORTED_DEF
void
bglfth_setup( int argc, char *argv, char **env ) {
#ifdef PTW32_VERSION
   /* Pthreads-win32 initialization */
   pthread_win32_process_attach_np();
#endif
   bglfth_setup_gc();
   bglfth_setup_bmem();
   bglfth_setup_mutex();
   bglfth_setup_condvar();
   bglfth_setup_thread();
}
