;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/everror.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 14 13:46:57 2004                          */
;*    Last change :  Sat Aug 12 15:31:33 2006 (serrano)                */
;*    Copyright   :  2004-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The error of evmeaning                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __everror
   
   (include "Eval/byte-code.sch")
   
   (import  __type
 	    __object
	    __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __os
	    __bit
	    __param
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3)
   
   (extern (macro $evmeaning-byte-code::obj ()
		  "BGL_BYTECODE")
	   (macro $evmeaning-byte-code-set!::obj (::obj)
		  "BGL_BYTECODE_SET"))
   
   (java   (class foreign
	      (method static $evmeaning-byte-code::obj ()
		      "BGL_BYTECODE")
	      (method static $evmeaning-byte-code-set!::obj (::obj)
		      "BGL_BYTECODE_SET")))
   
   (export (evmeaning-error ::obj ::obj ::obj ::obj)
	   (evmeaning-type-error ::obj ::obj ::obj ::obj)
	   (evmeaning-reset-error!)
	   (evmeaning-warning ::obj . ::obj)
	   (evmeaning-exception-handler ::obj)
	   (evmeaning-arity-error ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    evmeaning-reset-error! ...                                       */
;*---------------------------------------------------------------------*/
(define (evmeaning-reset-error!)
   ($evmeaning-byte-code-set! #f))
   
;*---------------------------------------------------------------------*/
;*    evmeaning-error ...                                              */
;*---------------------------------------------------------------------*/
(define (evmeaning-error bcode proc mes obj)
   (if (evcode? bcode)
       (match-case (evcode-loc bcode)
	  ((at ?fname ?loc)
	   (error/location proc mes obj fname loc))
	  (else
	   (error proc mes obj)))
       (error proc mes obj)))

;*---------------------------------------------------------------------*/
;*    evmeaning-type-error ...                                         */
;*---------------------------------------------------------------------*/
(define (evmeaning-type-error bcode proc mes obj)
   (if (evcode? bcode)
       (match-case (evcode-loc bcode)
	  ((at ?fname ?loc)
	   (bigloo-type-error/location proc mes obj fname loc))
	  (else
	   (bigloo-type-error proc mes obj)))
       (bigloo-type-error proc mes obj)))

   
;*---------------------------------------------------------------------*/
;*    evmeaning-warning ...                                            */
;*---------------------------------------------------------------------*/
(define (evmeaning-warning bcode . args)
   (if (evcode? bcode)
       (match-case (evcode-loc bcode)
	  ((at ?fname ?loc)
	   (warning-notify (make-&eval-warning fname loc args)))
	  (else
	   (warning-notify (make-&eval-warning #f #f args))))
       (warning-notify (make-&eval-warning #f #f args))))

;*---------------------------------------------------------------------*/
;*    evmeaning-exception-handler ...                                  */
;*    -------------------------------------------------------------    */
;*    This handler is just in charge of adding a location to           */
;*    the error/warning.                                               */
;*---------------------------------------------------------------------*/
(define (evmeaning-exception-handler e)
   (if (and (&exception? e)
	    (not (&exception-fname e))
	    (evcode? ($evmeaning-byte-code)))
       (match-case (evcode-loc ($evmeaning-byte-code))
	  ((at ?fname ?loc)
	   (&exception-fname-set! e fname)
	   (&exception-location-set! e loc)
	   (raise e))
	  (else
	   (raise e)))
       (raise e)))
   
;*---------------------------------------------------------------------*/
;*    evmeaning-arity-error ...                                        */
;*---------------------------------------------------------------------*/
(define (evmeaning-arity-error code name)
   (evmeaning-error code 'eval "Incorrect number of arguments" name))
	 
