/*
    This program can be distributed under the terms of the GNU GPL.
    See the file COPYING.

    Author: Martin Prtel <martin.partel@gmail.com>
*/

#ifndef INC_BINDFS_MISC_H
#define INC_BINDFS_MISC_H

/* Counts the number of times ch occurs in s. */
int count_chars(const char *s, char ch);

/* Counts the number of times sub occurs in s. */
int count_substrs(const char *s, const char *sub);

/* Creates a duplicate string of all the characters in s before
   an end character is reached. */
char *strdup_until(const char *s, const char *endchars);

/* Returns a pointer to the first character after the
   final slash of path, or path itself if it contains no slashes.
   If the path ends with a slash, then the result is an empty
   string.
   Returns NULL if path is NULL. */
const char *my_basename(const char *path);

#endif
