var bm = require("../shared-modules/bookmarks");

const TIMEOUT = 5000;

const LOCAL_TEST_FOLDER = collector.addHttpResource('../test-files/');
const LOCAL_TEST_PAGE = LOCAL_TEST_FOLDER + 'test.html';
const LOCAL_TEST_FEED = LOCAL_TEST_FOLDER + 'feed.atom';

var setupModule = function(module) {
    module.controller = mozmill.getBrowserController();
    module.jum = {}
    module.sync = {}
    module.fake_synchroniser = {
        guid_from_id: function (item_id) {
            return "guid:" + item_id;
        }
    }
    module.observer = null;
    Cu.import("resource://mozmill/modules/jum.js", module.jum);
    Cu.import("resource://bindwood/sync.jsm", module.sync);
};


var setupTest = function(test) {
    observer = new sync.BookmarksObserver(fake_synchroniser);
    bm.bookmarksService.addObserver(observer, false);
};

var teardownTest = function(test) {
    bm.bookmarksService.removeObserver(observer);
    bm.clearBookmarks();
};

var testQueryInterface = function() {
    jum.assertEquals(
        observer.QueryInterface(Ci.nsISupports), observer);
    jum.assertEquals(
        observer.QueryInterface(Ci.nsINavBookmarkObserver), observer);
    if (Ci.nsINavBookmarkObserver_MOZILLA_1_9_1_ADDITIONS) {
        jum.assertEquals(
            observer.QueryInterface(Ci.nsINavBookmarkObserver_MOZILLA_1_9_1_ADDITIONS), observer);
    }
};

var assertChanged = function (item_id) {
    var guid = fake_synchroniser.guid_from_id(item_id);
    return observer.changed_guids[guid] != null;
};

var assertNotChanged = function (item_id) {
    var guid = fake_synchroniser.guid_from_id(item_id);
    return observer.changed_guids[guid] == null;
};

var testClearChanges = function() {
    var dummy_id = 42;
    observer.record_change(dummy_id);
    assertChanged(dummy_id);
    observer.clear_changes(dummy_id);
    assertNotChanged(dummy_id);
};

var testAddBookmark = function() {
    var bookmark_id = bm.bookmarksService.insertBookmark(
        bm.bookmarksService.toolbarFolder,
        bm.createURI(LOCAL_TEST_PAGE),
        bm.bookmarksService.DEFAULT_INDEX,
        "Bookmark title");
    assertChanged(bookmark_id);
    assertChanged(bm.bookmarksService.toolbarFolder);
};

var testRemoveBookmark = function() {
    var bookmark_id = bm.bookmarksService.insertBookmark(
        bm.bookmarksService.toolbarFolder,
        bm.createURI(LOCAL_TEST_PAGE),
        bm.bookmarksService.DEFAULT_INDEX,
        "Bookmark title");
    observer.clear_changes();

    bm.bookmarksService.removeItem(bookmark_id);
    assertChanged(bookmark_id);
    assertChanged(bm.bookmarksService.toolbarFolder);
};

var testMoveBookmarkSameFolder = function() {
    var folder_id = bm.bookmarksService.createFolder(
        bm.bookmarksService.toolbarFolder,
        "Folder", bm.bookmarksService.DEFAULT_INDEX);
    var bookmark1_id = bm.bookmarksService.insertBookmark(
        folder_id, bm.createURI(LOCAL_TEST_PAGE + "#one"),
        bm.bookmarksService.DEFAULT_INDEX, "Bookmark 1");
    var bookmark2_id = bm.bookmarksService.insertBookmark(
        folder_id, bm.createURI(LOCAL_TEST_PAGE + "#two"),
        bm.bookmarksService.DEFAULT_INDEX, "Bookmark 2");
    observer.clear_changes();

    // If we move a bookmark within the same folder (i.e. no parent
    // change), then only the parent folder has changed.
    bm.bookmarksService.moveItem(bookmark2_id, folder_id, 0);
    assertChanged(folder_id);
    assertNotChanged(bookmark2_id);
};

var testMoveBookmarkDifferentFolder = function() {
    var folder1_id = bm.bookmarksService.createFolder(
        bm.bookmarksService.toolbarFolder,
        "Folder 1", bm.bookmarksService.DEFAULT_INDEX);
    var folder2_id = bm.bookmarksService.createFolder(
        bm.bookmarksService.toolbarFolder,
        "Folder 2", bm.bookmarksService.DEFAULT_INDEX);
    var bookmark_id = bm.bookmarksService.insertBookmark(
        folder1_id, bm.createURI(LOCAL_TEST_PAGE),
        bm.bookmarksService.DEFAULT_INDEX, "Bookmark");
    observer.clear_changes();

    bm.bookmarksService.moveItem(
        bookmark_id, folder2_id, bm.bookmarksService.DEFAULT_INDEX);
    // The item is changed because it has a new parent.  The two
    // folders have changed because their child lists have changed.
    assertChanged(bookmark_id);
    assertChanged(folder1_id);
    assertChanged(folder2_id);
};

var testLivemarkChildrenIgnored = function() {
    var livemark_id = bm.livemarkService.createLivemark(
        bm.bookmarksService.toolbarFolder,
        "Test Feed",
        bm.createURI("http://www.example.com/"),
        bm.createURI(LOCAL_TEST_FEED),
        bm.bookmarksService.DEFAULT_INDEX);

    // Wait for the livemark to load, then check that it has been
    // loaded correctly.
    var livemark_child_id;
    controller.waitFor(function() {
            livemark_child_id = bm.bookmarksService.getIdForItemAt(
                livemark_id, 0);
            return livemark_child_id >= 0;
        }, TIMEOUT);
    var livemark_child_uri = bm.bookmarksService.getBookmarkURI(
        livemark_child_id);
    jum.assertEquals(livemark_child_uri.spec, LOCAL_TEST_PAGE);

    // Only the livemark itself is recorded as changed: the children
    // are ignored.
    assertChanged(livemark_id);
    assertNotChanged(livemark_child_id);
}
