/**
 * Copyright Copr. INRIA/INRA
 * Contact :  biomaj_AT_genouest.org
 * 
 * BioMAJ is a workflow engine dedicated to biological bank management. 
 * The Software automates the update cycle and the supervision of the locally 
 * mirrored bank repository. The project is a collaborative effort between two 
 * French Research Institutes INRIA (Institut National de Recherche en
 * Informatique 
 * et en Automatique) & INRA (Institut National de la Recherche Agronomique).
 *
 * Inter Deposit Digital Number : IDDN ...................................
 *
 * This software is governed by the CeCILL-A license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-A license and that you accept its terms.
 */


package org.inria.biomaj.exe.options;

import java.util.List;
import java.util.Map;
import java.util.Vector;


import org.inria.biomaj.session.bank.Bank;
import org.inria.biomaj.session.bank.BiomajSQLQuerier;
import org.inria.biomaj.session.bank.Session;
import org.inria.biomaj.utils.BiomajException;


public class GenStatistiquesChart {
	
	public static Vector<ObjectStat> getStatVectorSize(String bankName) throws BiomajException {

		Vector<ObjectStat> result = new Vector<ObjectStat>();

		List<Map<String, String>> updates = BiomajSQLQuerier.getBankUpdates(bankName, false);
		
		for (Map<String, String> update : updates) {
			Bank bank = new Bank();
			bank.setLoadMessages(false);
			bank.fill(update,true);

			if (!bank.getWorkflowInfoIsDeployed())
				continue;

			ObjectStat os = new ObjectStat();

			float bandwidth = bank.getBandWidth() ;
			os.setBandWidth(bandwidth);

			if ((bank.getEnd()!=null)&&(bank.getStart()!=null))
				os.setGlobalTime(bank.getEnd().getTime()-bank.getStart().getTime());
			else {
				//version verrole, on passe
				continue;
			}
			os.setNbFileDownload(bank.getNbFilesDownloaded());
			//os.setNbFileFlat(bank.getNbFilesMoves());
			os.setNbSession(bank.getListOldSession().size());
			os.setRelease(bank.getWorkflowInfoRelease());
			os.setSize(bank.getWorkflowInfoSizeRelease());
			os.setTime(bank.getEnd());
			os.setSizeCompressed(bank.getWorkflowInfoSizeDownload());
			long t = 0;
			//System.out.println(bankName + " nbSession:"+bank.getListSession().size());
			for (Session s:bank.getListOldSession()) {
				//System.out.println(bankName + " id:"+s.getId());
				//System.out.println(bankName + " start:"+BiomajUtils.dateToString(s.getStart()));
				//System.out.println(bankName + " end:"+BiomajUtils.dateToString(s.getEnd()));
				if (s.getEnd()!=null)
					t += (s.getEnd().getTime()-s.getStart().getTime());
			}
			os.setTrueTime(t);

			result.add(os);
		}		
		/*
		if (result.size()==1)
			result.remove(0);
		 */
		return result;
	}


}
