/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>

#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <wordexp.h>
#include <sys/stat.h>
#include <dirent.h>
#include <cerrno>
//portability problem?
#include <pthread.h>

#include <cstdio>


#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_Dialog.H>
#include <FL/Fl_Check_Button.H>
//#include <FL/Fl_PNG_Image.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>

#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <prefs.hpp>

#include <set_conf.hpp>
#include <command_line.hpp>
#include <util.hpp>



#include <global_charge.hpp>

//#include <global_charge_dialog.hpp>

extern finestra_pr* __la_finestra;

extern Preferences  __pref;

extern bool __close;




/**
 *Un plugin deve avere :
 *
 *una funzione  bool (*need_group)()  che ritorna true  se il  plugin ha
 *bisogno di conoscre quali atomi sono selezionati;
 *
 *una funzione  bool (*need_leg)()  che ritorna true  se il  plugin ha
 *bisogno di conoscere quali legami sono selezionati;
 *
 *una funzione  bool (*act)()  che computa quello  per cui il  plugin e'
 *stato scritto
 *
 */



global_charge::global_charge(immagine* image,string libpath)
  :bist_plugin(image,libpath),
   _has_to_act(true),
   _has_acted(false),
   _charges("")
  
{
  
}


void global_charge::inizialize(){
  /*  
 _the_image->elimina_elem_selected();
 _the_image->elimina_legami_selected();
  */
  _has_acted=true;  
  const char* the_charges=fl_input("Charges","0");
  if(the_charges!=NULL){
    _charges=the_charges;
    act(0);
  }

}


bool global_charge::need_atom(){
  return false;
}

bool global_charge::need_leg(){
  return false;
}

bool global_charge::act(int e){
  /**
   *Contiene  coppie <tipo, < gruppo, id > > selezionati, se  si e'
   *selezionato una etichetta gruppo e' uguale a NO_VALID_GROUP
   */

  vector< pair < int, pair<int,int> > >* elem=r_elem_selected();

  if(elem->size()>0){
    float arr_w=__pref.get_arr_w();
    float arr_h=__pref.get_arr_h();
    float arr_gap=__pref.get_arr_gap();
    vector <gruppo>* gruppi=r_groups();
    //(*elem)[el_sel].second.first
    if((*elem)[0].second.first!=NO_VALID_GROUP){
      for(unsigned int y=0;y<gruppi->size();y++){
	if((*gruppi)[y].id_gruppo()==((*elem)[0].second).first){
	  float px=(*gruppi)[y].phys_posx();
	  float py=(*gruppi)[y].phys_posy();
	  float w=(*gruppi)[y].phys_w();
	  float h=(*gruppi)[y].phys_h();
          std::cerr << "px: " << px << "py " << py
                    << "w " << w << "h " << h << std::endl;

	  /*
	    proc_arrow(int id,float posx, float posy,
	    float eposx,float eposy,
	    int cr, int cb, int cg ,
	    float xpiv, float ypiv, float anglrot,
	    int spess, int tratt, int punte)
	  */
	
	  proc_arrow hor(0,10+px+w*3/4, -10+py,
			 10+px+w,-10+py,
			 0, 0,0,
			 0,0,0,
			 2,0, ARR_NO_PUNT,
			 arr_w,arr_h,arr_gap);

	
	  proc_arrow ver(0,10+px+w, -10+py,
			 10+px+w,-10+py+h/4,
			 0, 0,0,
			 0,0,0,
			 2,0, ARR_NO_PUNT,
			 arr_w,arr_h,arr_gap);
	
	  (*gruppi)[y].aggiungi_procedura(&hor);
	  (*gruppi)[y].aggiungi_procedura(&ver);


	  paragraph_text* ch=new paragraph_text();
	  ch->insert_string_in_curr_pos(_charges,ET_STR);
	  ch->trasla(12+px+w,-12+py);
	  _the_image->aggiungi_etich(ch);
	  //_the_image->redraw();
	  break;
	}
      }
    }


  }
  return _has_acted;
}


global_charge::~global_charge(){
  
  cout << "global_charge distruzione!!! " << _the_image <<endl;
}

void global_charge::register_plugin(){

}

 
bool global_charge::time_to_act(){
  //cout << endl << "has_acted" << _has_acted << endl;
  bool res=false;
  if(r_elem_selected()->size()>0 && !_has_acted){
    _has_to_act=true;
    res=true;
  }
  return res;
}
    

string global_charge::libpath(){
  return _lib;
}



/**************fine metodi di classe**********************************/




extern "C" bist_plugin* create_plugin(immagine* imm, string libpath){
  return new global_charge(imm, libpath);
}

extern "C" void destroy_plugin(bist_plugin* j){
  cout << "distruzione plugin: " << j <<  endl;
  delete j;
  cout << "riuscita" << endl;
}


