/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <config_path.h>
#include <sys/stat.h>
#include <dirent.h>

#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Help_Dialog.H>
//#include <FL/Fl_PNG_Image.H>


#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>

#include <util.hpp>

#include <finestra_pr.hpp>
#include <editor.hpp>
#include <bond_prop.hpp>
#include <string_prop.hpp>

#include <Flu_Enumerations.h>
#include <Flu_Tree_Browser.h>

#include <lib_dialog.hpp>


void lib_dialog_tree_callback(Fl_Widget* w, void* ){
  string home_dir=getenv("HOME");
  Flu_Tree_Browser *t = dynamic_cast<Flu_Tree_Browser*>(w);
  lib_dialog* dia=dynamic_cast<lib_dialog*>(w->parent());

  int reason = t->callback_reason();
  Flu_Tree_Browser::Node *n = t->callback_node();

  if(n->is_leaf()){

    switch( reason )
      {
      case FLU_HILIGHTED:
	{
	  string path=n->find_path();
	  if(path.find(dia->home_bra)!=string::npos){
	    path=home_dir + LIB_PATH_HOME +path.substr(dia->home_bra.size()+1);
	  }else{ //allora e share_bra
	    path=LIB_PATH_SHARE+path.substr(dia->share_bra.size()+1);
	  }

	  //check
	  dia->_imm->reset_all();
	  dia->_imm->filebist(path);
	  dia->_imm->start();
	  //dia->_preview.add_immagine(dia->_imm);
	  dia->_imm->print_warn();
	  dia->_imm->print_errors();
	  dia->redraw();

	  break;
	}
      case FLU_DOUBLE_CLICK:
	//printf( "%s double-clicked\n", n->label() );
	string path=n->find_path();
	if(path.find(dia->home_bra)!=string::npos){
	  path=home_dir + LIB_PATH_HOME +path.substr(dia->home_bra.size()+1);
	}else{ //allora e share_bra
	  path=LIB_PATH_SHARE+path.substr(dia->share_bra.size()+1);
	}
	dia->_template_file=path;
	dia->hide();
	break;
      }

  }
}


string lib_dialog::get_template_file(){
  return _template_file;
}

lib_dialog::lib_dialog()
  :Fl_Double_Window(W_D,H_D,_("Insert object")),
   //   _grp(10+W_TREE+GAP_ELE*2+GAP_BOX,GAP_BOX,W_TREE+GAP_ELE, H_TREE+GAP_ELE),
   //_tree(GAP_BOX+GAP_ELE, GAP_BOX+GAP_ELE, W_TREE, H_TREE),
   _preview(10+GAP_ELE*3+W_TREE+GAP_BOX,
	    GAP_ELE+GAP_BOX,
	    W_TREE*3-GAP_ELE,
	    H_TREE*3-GAP_ELE)

   
{

  string home_dir=getenv("HOME");
  _preview.action(ACT_NOTHING);
  _imm=new immagine(true);
  _grp=new Fl_Scroll(10+W_TREE+GAP_ELE*2+GAP_BOX,GAP_BOX,W_TREE+GAP_ELE, H_TREE+GAP_ELE);
  _grp->type(Fl_Scroll::BOTH_ALWAYS);
  _grp->box(FL_UP_FRAME);
  _grp->add(_preview);
  _preview.add_immagine(_imm);
  add(_grp); 

  _tree=new Flu_Tree_Browser(GAP_BOX+GAP_ELE, GAP_BOX+GAP_ELE, W_TREE, H_TREE);
  _tree->box(FL_UP_FRAME);
  _tree->callback(lib_dialog_tree_callback);
  _tree->animate(true);
  _tree->set_root(_("Library"));
  _tree->all_branches_always_open(true);
  _tree->always_open(true);
  _tree->selection_mode(FLU_SINGLE_SELECT);
  make_tree(home_dir + LIB_PATH_HOME );
  make_tree(LIB_PATH_SHARE);
  add(_tree);
  end();
  set_modal();
}


lib_dialog::~lib_dialog(){
  //  cout << "Chiamato distruttore lib_dialog" << endl;
  delete _imm;
}

void lib_dialog::make_tree(string pt){
  string home_dir=getenv("HOME");
  DIR* direc=opendir(pt.c_str());

  if(direc==NULL){
    fl_alert(_("Can not open library directory %s"),pt.c_str());
    return;
  }

  dirent* acc;
  struct stat attrb;
  while((acc=readdir(direc))!=NULL){
    string file=pt+"/"+acc->d_name;
    stat(file.c_str(),&attrb);
    if(S_ISDIR(attrb.st_mode) && 
       string(acc->d_name)!="." &&
       string(acc->d_name)!=".."){
      string::size_type pos=file.find(home_dir + LIB_PATH_HOME );
      string pt="";
	if(pos!=string::npos){
	  pt=file.substr(string(home_dir + LIB_PATH_HOME ).size());
	  pt=home_bra+pt;
	}else{
	  //pos=file.find(LIB_PATH_SHARE);
	  pt=file.substr(string(LIB_PATH_SHARE).size());
	  pt=share_bra+pt;
	}
      _tree->add_branch(pt.c_str());
      make_tree(file);
    }else if(S_ISREG(attrb.st_mode)){
      string::size_type pos=file.find(home_dir + LIB_PATH_HOME );
      string pt;
      if(pos!=string::npos){
	pt=file.substr(string(home_dir + LIB_PATH_HOME ).size());
	pt=home_bra+pt;

      }else{
	pt=file.substr(string(LIB_PATH_SHARE).size());
	pt=share_bra+pt;
       
      }
      //cout << "pt " << pt << endl;
      _tree->add_leaf(pt.c_str());
    }
  }
  
}


Fl_Scroll*  lib_dialog::ritorna_scroll(){
  return _grp;
}

immagine*   lib_dialog::ritorna_immagine(){
  return _imm;
}

mol_canvas* lib_dialog::ritorna_mol_canvas(){
  return &_preview;
}

const  string lib_dialog::home_bra=_("home");
const  string lib_dialog::share_bra=_("shared");
