#include <global.hpp>
#include <cstdio>


#include <cairo/cairo.h>
#include <pango/pangocairo.h>


#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_Dialog.H>
//#include <FL/Fl_PNG_Image.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <util.hpp>
#include <prefs.hpp>



Preferences::Preferences() { Defaults(); }
void Preferences::Defaults() {
  fixed_arrow = true;
    arrow_fixedlength = LENGHT_BOND;
    arrow_fixedangle = ANGL_BOND;
    fixed_bond = true;

    fix_hydrogens = true;

    paper_size = PAGE_A4;
    paper_orient = PAGE_PORTRAIT;
    paper_width = PAPER_W_STD;
    paper_height = PAPER_H_STD;
    units = PIXELS;

    snapgrid = GRID_NONE;
 
    splash = true;
    dykcount = 0;
    zoom = 1.0;

    magnetic_point_gap=0;

    mono_font="Courier 10 Pitch";
    sans_font="Sans";
    serif_font="Serif";

    mono_font_bold="Mono Bold";
    sans_font_bold="Sans Bold";
    serif_font_bold="Serif Bold";


    mono_font_italic="Mono Italic";
    sans_font_italic="Sans Italic";
    serif_font_italic="Serif Italic";

    mono_font_bold_italic="Mono Bold Italic";
    sans_font_bold_italic="Sans Bold Italic";
    serif_font_bold_italic="Serif Bold Italic";


    symbol_font="Symbol";

    dingbats_font="Dingbats";

    gridspace = 25;
    gridmode = GRID_NONE;
    drawgrid = GRID_NONE;
    bond_fixedlength = LENGHT_BOND;
    bond_fixedangle = ANGL_BOND;
    dbond_offset = SPACE_BOND;    
    tratteggio_legame=TRATTEGGIO_LEGAME;
    larg_max_cuneo = LARG_MAX_CUNEO;
    larg_min_cuneo = LARG_MIN_CUNEO;
    width_single_bond=LARG_SINGLE_BOND;

    sensib_leg=SENSIB_LEG;
    arr_w = ARR_W;
    arr_h =ARR_H;
    arr_gap=ARR_GAP;
    multiple_bond_gap= MULTIPLE_BOND_GAP;
    ampiezza_stereo_scon = AMPIEZZA_STEREO_SCON;
    frequenza_stereo_scon = FREQUENZA_STEREO_SCON;
    num_barrette_stereo_down = NUM_BARRETTE_STEREO_DOWN;
    
  }

  void Preferences::setFile(std::string fn, bool fb) {
    fileName = fn;
    fallback = fb;
  }

  void Preferences::setSaveFile(std::string fn) {
    saveFileName = fn;
  }

bool Preferences::LoadPrefs() {
    std::ifstream fin(fileName.c_str());

    if(!fin){
      cout << _("file ") << fileName.c_str() << _("do not exists") << endl;
    }

    /*
    if (fin.open(IO_ReadOnly) == false)
      return false;
    */

    //    QTextStream tin(&fin);
    std::string line;
    
    do {
      getline(fin,line,'\n'); //tin.readLine();
      //cout << PREF: << line << endl;
      if (line.find(PREFS_FIXED_ARROW) !=std::string::npos) {
	if (line.find(PREFS_TRUE)){
	  fixed_arrow = true;
	}else{
	  fixed_arrow = false;
	  
	}
      }
      if (line.find(PREFS_FIXED_BOND) !=std::string::npos) {
	if (line.find(PREFS_TRUE) !=std::string::npos)
	  fixed_bond = true;
	else
	  fixed_bond = false;
      }
      if (line.find(PREFS_FIX_HYDROGENS) !=std::string::npos) {
	if (line.find(PREFS_TRUE) !=std::string::npos )
	  fix_hydrogens = true;
	else
	  fix_hydrogens = false;
      }
      if (line.find(PREFS_SPLASH) !=std::string::npos) {
	if (line.find(PREFS_TRUE) !=std::string::npos){
	  splash = true;
	}else{
	  splash = false;
	}
      }
      if (line.find(PREFS_ARROW_LENGTH) !=std::string::npos) {
	arrow_fixedlength = strtof(line.substr(strlen (PREFS_ARROW_LENGTH)).c_str(),NULL);
      }
      if (line.find(PREFS_ARROW_ANGLE) !=std::string::npos) {
	arrow_fixedangle = strtof(line.substr(strlen(PREFS_ARROW_ANGLE)).c_str(),NULL);
      }
      if (line.find(PREFS_BOND_LENGTH) !=std::string::npos) {
	bond_fixedlength = strtof(line.substr(strlen(PREFS_BOND_LENGTH)).c_str(),NULL);
      }
      if (line.find(PREFS_BOND_ANGLE) !=std::string::npos) {
	bond_fixedangle = strtof(line.substr(strlen(PREFS_BOND_ANGLE)).c_str(),NULL);
      }
      if (line.find(PREFS_DBOND_OFFSET) !=std::string::npos) {
	dbond_offset = strtof(line.substr(strlen(PREFS_DBOND_OFFSET)).c_str(),NULL);
      }

      if(line.find(PREFS_ARR_W) !=std::string::npos) {
	arr_w = strtof(line.substr(strlen(PREFS_ARR_W)).c_str(),NULL);
      }
      
      if(line.find(PREFS_ARR_H) !=std::string::npos) {
	arr_h = strtof(line.substr(strlen(PREFS_ARR_H)).c_str(),NULL);
      }

      if(line.find(PREFS_ARR_GAP) !=std::string::npos) {
	arr_gap = strtof(line.substr(strlen(PREFS_ARR_GAP)).c_str(),NULL);
      }

      if(line.find(PREFS_MULTIPLE_BOND_GAP) !=std::string::npos) {
	multiple_bond_gap = strtof(line.substr(strlen(PREFS_MULTIPLE_BOND_GAP)).c_str(),NULL);
      }
      
      if (line.find(PREFS_SENSIB_LEG) !=std::string::npos) {
	sensib_leg = static_cast<int>(strtol(line.substr(strlen(PREFS_SENSIB_LEG)).c_str()
                                             ,NULL,0));
      }
      
      
      if(line.find(PREFS_LARG_MAX_CUNEO) !=std::string::npos) {
	larg_max_cuneo = strtof(line.substr(strlen(PREFS_LARG_MAX_CUNEO)).c_str(),NULL);
      }

      if(line.find(PREFS_LARG_MIN_CUNEO) !=std::string::npos) {
	larg_max_cuneo = strtof(line.substr(strlen(PREFS_LARG_MIN_CUNEO)).c_str(),NULL);
      }
      
      if(line.find(PREFS_AMPIEZZA_STEREO_SCON) !=std::string::npos) {
	ampiezza_stereo_scon = strtof(line.substr(strlen(PREFS_AMPIEZZA_STEREO_SCON)).c_str(),NULL);
      }

      if(line.find(PREFS_FREQUENZA_STEREO_SCON) !=std::string::npos) {
	frequenza_stereo_scon = strtof(line.substr(strlen(PREFS_FREQUENZA_STEREO_SCON)).c_str(),
                                       NULL);
      }

            
      if(line.find(PREFS_TRATTEGGIO_LEGAME) !=std::string::npos) {
	tratteggio_legame = static_cast<int>(strtol(line.substr(strlen(PREFS_TRATTEGGIO_LEGAME)).c_str(),
                                                    NULL,0));
      }


      //int


      if (line.find(PREFS_NUM_BARRETTE_STEREO_DOWN) !=std::string::npos) {
	num_barrette_stereo_down = static_cast<int>(strtol(line.substr(strlen(PREFS_NUM_BARRETTE_STEREO_DOWN)).c_str(),
                                                           NULL,0));
      }

      if (line.find(PREFS_MAGNETIC_POINT_GAP) !=std::string::npos) {
	magnetic_point_gap = static_cast<int>(strtol(line.substr(strlen(PREFS_MAGNETIC_POINT_GAP)).c_str(),NULL,0));
        
      }

      if (line.find(PREFS_SANS_FONT ) !=std::string::npos) {
	sans_font = trim(line.substr(strlen(PREFS_SANS_FONT)));
        
      }

      if (line.find(PREFS_MONO_FONT ) !=std::string::npos) {
	mono_font  = trim(line.substr(strlen(PREFS_MONO_FONT)));
        
      }

      if (line.find(PREFS_SERIF_FONT ) !=std::string::npos) {
	serif_font = trim(line.substr(strlen(PREFS_SERIF_FONT)));
        
      }




      if (line.find(PREFS_SANS_FONT_ITALIC ) !=std::string::npos) {
	sans_font_italic = trim(line.substr(strlen(PREFS_SANS_FONT_ITALIC)));
        
      }

      if (line.find(PREFS_MONO_FONT_ITALIC ) !=std::string::npos) {
	mono_font_italic  = trim(line.substr(strlen(PREFS_MONO_FONT_ITALIC)));
        
      }

      if (line.find(PREFS_SERIF_FONT_ITALIC ) !=std::string::npos) {
	serif_font_italic = trim(line.substr(strlen(PREFS_SERIF_FONT_ITALIC)));
        
      }



      if (line.find(PREFS_SANS_FONT_BOLD ) !=std::string::npos) {
	sans_font_bold = trim(line.substr(strlen(PREFS_SANS_FONT_BOLD)));
        
      }

      if (line.find(PREFS_MONO_FONT_BOLD ) !=std::string::npos) {
	mono_font_bold  = trim(line.substr(strlen(PREFS_MONO_FONT_BOLD)));
        
      }

      if (line.find(PREFS_SERIF_FONT_BOLD ) !=std::string::npos) {
	serif_font_bold = trim(line.substr(strlen(PREFS_SERIF_FONT_BOLD)));
        
      }



      if (line.find(PREFS_SANS_FONT_BOLD_ITALIC ) !=std::string::npos) {
	sans_font_bold_italic = trim(line.substr(strlen(PREFS_SANS_FONT_BOLD_ITALIC)));
        
      }

      if (line.find(PREFS_MONO_FONT_BOLD_ITALIC ) !=std::string::npos) {
	mono_font_bold_italic  = trim(line.substr(strlen(PREFS_MONO_FONT_BOLD_ITALIC)));
        
      }

      if (line.find(PREFS_SERIF_FONT_BOLD_ITALIC ) !=std::string::npos) {
	serif_font_bold_italic = trim(line.substr(strlen(PREFS_SERIF_FONT_BOLD_ITALIC)));
        
      }


      if (line.find(PREFS_SYMBOL_FONT ) !=std::string::npos) {
	symbol_font = trim(line.substr(strlen(PREFS_SYMBOL_FONT)));
        
      }


      if (line.find(PREFS_DINGBATS_FONT ) !=std::string::npos) {
	symbol_font = trim(line.substr(strlen(PREFS_DINGBATS_FONT)));
        
      }


      if (line.find(PREFS_PAPER_SIZE) !=std::string::npos) {
	paper_size = static_cast<int>(strtol(line.substr(strlen(PREFS_PAPER_SIZE)).c_str(),NULL,0));
      }
      if (line.find(PREFS_PAPER_ORIENT) !=std::string::npos) {
	paper_orient = static_cast<int>(strtol(line.substr(strlen(PREFS_PAPER_ORIENT)).c_str(),NULL,0));
      }
      if (line.find(PREFS_PAPER_WIDTH) !=std::string::npos) {
	paper_width = static_cast<int>(strtol(line.substr(strlen(PREFS_PAPER_WIDTH)).c_str(),NULL,0));
      }
      if (line.find(PREFS_PAPER_HEIGHT) !=std::string::npos) {
	paper_height = static_cast<int>(strtol(line.substr(strlen(PREFS_PAPER_HEIGHT)).c_str(),NULL,0));
      }
      if (line.find(PREFS_UNITS) !=std::string::npos) {
	units = static_cast<int>(strtol(line.substr(strlen(PREFS_UNITS)).c_str(),NULL,0));
      }
      if (line.find(PREFS_DRAWGRID) !=std::string::npos) {
	drawgrid = static_cast<int>(strtol(line.substr(strlen(PREFS_DRAWGRID)).c_str(),NULL,0));
      }
      if (line.find(PREFS_SNAPGRID) !=std::string::npos) {
	snapgrid = static_cast<int>(strtol(line.substr(strlen(PREFS_SNAPGRID)).c_str(),NULL,0));
      }
      if (line.find(PREFS_DYKCOUNT) !=std::string::npos) {
	dykcount = static_cast<int>(strtol(line.substr(strlen(PREFS_DYKCOUNT)).c_str(),NULL,0));
      }
      if (line.find(PREFS_GRIDMODE) !=std::string::npos) {
	gridmode = static_cast<int>(strtol(line.substr(strlen(PREFS_GRIDMODE)).c_str(),NULL,0));
      }
      if (line.find(PREFS_GRIDSPACE) !=std::string::npos) {
	gridspace = static_cast<int>(strtol(line.substr(strlen(PREFS_GRIDSPACE)).c_str(),NULL,0));
      }
      if(line.find(PREFS_WIDTH_SINGLE_BOND) !=std::string::npos) {
        width_single_bond=strtof(line.substr(strlen(PREFS_WIDTH_SINGLE_BOND)).c_str(),NULL);
      }


    } while (!fin.eof());

    fin.close();

    return true;
  }
  
bool Preferences::SavePrefs() {
  std::ofstream tout(saveFileName.c_str());
    
    if (fixed_arrow)
      tout << PREFS_FIXED_ARROW << " " << PREFS_TRUE << endl;
    else
      tout << PREFS_FIXED_ARROW << " " << PREFS_FALSE << endl;
    if (fixed_bond)
      tout << PREFS_FIXED_BOND  << " " << PREFS_TRUE << endl;
    else
      tout << PREFS_FIXED_BOND   << " "<< PREFS_FALSE << endl;
    if (fix_hydrogens)
      tout << PREFS_FIX_HYDROGENS  << " " << PREFS_TRUE << endl;
    else
      tout << PREFS_FIX_HYDROGENS  << " " << PREFS_FALSE << endl;
    if (splash)
      tout << PREFS_SPLASH << " "  << PREFS_TRUE << endl;
    else
      tout << PREFS_SPLASH  << " " << PREFS_FALSE << endl;
    tout << PREFS_DYKCOUNT  << " "<< dykcount << endl;
    tout << PREFS_ARROW_LENGTH  << " "<< arrow_fixedlength << endl;

    tout << PREFS_ARR_W  << " "<< arr_w << endl;
    tout << PREFS_ARR_H  << " "<< arr_h << endl;
    tout << PREFS_ARR_GAP  << " "<< arr_gap << endl;
    tout << PREFS_MULTIPLE_BOND_GAP<< " "  << multiple_bond_gap << endl;
    tout << PREFS_SENSIB_LEG  << " "<<  sensib_leg << endl;
    tout << PREFS_LARG_MAX_CUNEO   << " " << larg_max_cuneo << endl;
    tout << PREFS_LARG_MIN_CUNEO   << " " << larg_max_cuneo << endl;
    tout << PREFS_TRATTEGGIO_LEGAME  << " "<< tratteggio_legame << endl;
    tout << PREFS_AMPIEZZA_STEREO_SCON  << " "<< ampiezza_stereo_scon << endl;
    tout << PREFS_FREQUENZA_STEREO_SCON  << " "<< frequenza_stereo_scon << endl;
    tout << PREFS_NUM_BARRETTE_STEREO_DOWN  << " "<< num_barrette_stereo_down << endl;

    tout << PREFS_ARROW_ANGLE  << " "<< arrow_fixedangle << endl;
    tout << PREFS_BOND_LENGTH  << " "<< bond_fixedlength << endl;
    tout << PREFS_BOND_ANGLE  << " "<< bond_fixedangle << endl;
    tout << PREFS_DBOND_OFFSET  << " "<< dbond_offset << endl;
    tout << PREFS_PAPER_SIZE  << " "<< paper_size << endl;
    tout << PREFS_PAPER_ORIENT  << " "<< paper_orient << endl;
    tout << PREFS_PAPER_WIDTH  << " "<< paper_width << endl;
    tout << PREFS_PAPER_HEIGHT  << " "<< paper_height << endl;
    tout << PREFS_UNITS  << " "<< units << endl;
    tout << PREFS_DRAWGRID  << " "<< drawgrid << endl;
    tout << PREFS_SNAPGRID  << " "<< snapgrid << endl;
    tout << PREFS_GRIDMODE  << " "<< gridmode << endl;
    tout << PREFS_GRIDSPACE  << " "<< gridspace << endl;
    tout << PREFS_MAGNETIC_POINT_GAP << " " << magnetic_point_gap << endl;
    tout << PREFS_SANS_FONT  << " "<< sans_font << endl;
    tout << PREFS_MONO_FONT  << " "<< mono_font << endl;
    tout << PREFS_SERIF_FONT  << " "<< serif_font << endl;

    tout << PREFS_SANS_FONT_ITALIC  << " "<< sans_font_italic << endl;
    tout << PREFS_MONO_FONT_ITALIC  << " "<< mono_font_italic << endl;
    tout << PREFS_SERIF_FONT_ITALIC  << " "<< serif_font_italic << endl;


    tout << PREFS_SANS_FONT_BOLD  << " "<< sans_font_bold << endl;
    tout << PREFS_MONO_FONT_BOLD  << " "<< mono_font_bold << endl;
    tout << PREFS_SERIF_FONT_BOLD  << " "<< serif_font_bold << endl;


    tout << PREFS_SANS_FONT_BOLD_ITALIC  << " "<< sans_font_bold_italic << endl;
    tout << PREFS_MONO_FONT_BOLD_ITALIC  << " "<< mono_font_bold_italic << endl;
    tout << PREFS_SERIF_FONT_BOLD_ITALIC  << " "<< serif_font_bold_italic << endl;
    tout << PREFS_SYMBOL_FONT  << " "<< symbol_font << endl;
    tout << PREFS_DINGBATS_FONT  << " "<< dingbats_font << endl;
    tout.close();

    return true;
  }

  float Preferences::get_arr_w(){
    return arr_w;
  }

  void Preferences::set_arr_w(float nw){
    arr_w=nw;
  }

  float Preferences::get_ampiezza_stereo_scon(){
    return ampiezza_stereo_scon;
  }

  void Preferences::set_ampiezza_stereo_scon(float nw){
    ampiezza_stereo_scon=nw;
  }
  
  float Preferences::get_frequenza_stereo_scon(){
    return frequenza_stereo_scon;
  }

  void Preferences::set_frequenza_stereo_scon(float nw){
    frequenza_stereo_scon=nw;
  }
  

  float Preferences::get_arr_h(){
    return arr_h;
  }

  void Preferences::set_arr_h(float nw){
    arr_h=nw;
  }


  float Preferences::get_arr_gap(){
    return arr_gap;
  }

  void Preferences::set_arr_gap(float nw){
    arr_gap=nw;
  }


  float Preferences::get_multiple_bond_gap(){
    return multiple_bond_gap;
  }

  void Preferences::set_multiple_bond_gap(float nw){
    multiple_bond_gap=nw;
  }

  int Preferences::get_sensib_leg(){
    return sensib_leg;
  }

  void  Preferences::set_sensib_leg(int nw){
    sensib_leg=nw;
  }

  int Preferences::get_tratteggio_legame(){
    return tratteggio_legame;
  }

  void  Preferences::set_tratteggio_legame(int nw){
    tratteggio_legame=nw;
  }


  int Preferences::get_num_barrette_stereo_down(){
    return num_barrette_stereo_down;
  }

  void  Preferences::set_num_barrette_stereo_down(int nw){
    num_barrette_stereo_down=nw;
  }



  float Preferences::get_larg_max_cuneo(){
    return larg_max_cuneo;
  }

  void Preferences::set_larg_max_cuneo(float nw){
    larg_max_cuneo=nw;
  }


  float Preferences::get_larg_min_cuneo(){
    return larg_max_cuneo;
  }

void Preferences::set_larg_min_cuneo(float nw){
  larg_max_cuneo=nw;
}


float Preferences::get_width_single_bond(){
  return width_single_bond;
}

void Preferences::set_width_single_bond(float nw){
  width_single_bond=nw;
}

bool Preferences::getArrow_fixed() { return fixed_arrow; }
  double Preferences::getArrow_fixedlength() { return arrow_fixedlength; }
  double Preferences::getArrow_fixedangle() { return arrow_fixedangle; }
  bool Preferences::getBond_fixed() { return fixed_bond; }
  double Preferences::getBond_fixedlength() { return bond_fixedlength; }
  double Preferences::getBond_fixedangle() { return bond_fixedangle; }
  bool Preferences::getAntialiased() { return antialiased; }
  bool Preferences::getFixHydrogens() { return fix_hydrogens; }
  int Preferences::getPageSize() { return paper_size; }
  int Preferences::getPageOrientation() { return paper_orient; }
  void Preferences::setPageSize(int n1) { paper_size = n1; }
  void Preferences::setPageOrientation(int n1) { paper_orient = n1; }
  void Preferences::setFixHydrogens(bool n1) { fix_hydrogens = n1; }
  void Preferences::setArrow_fixed(bool n1) { fixed_arrow = n1; }
  void Preferences::setArrow_fixedlength(double n1) { arrow_fixedlength = n1; }
  void Preferences::setArrow_fixedangle(double n1) { arrow_fixedangle = n1; }
  void Preferences::setBond_fixed(bool n1) { fixed_bond = n1; }
  void Preferences::setBond_fixedlength(double n1) { bond_fixedlength = n1; }
  void Preferences::setBond_fixedangle(double n1) { bond_fixedangle = n1; }
  void Preferences::setAntialiased(bool n1) { antialiased = n1; }
  double Preferences::getDoubleBondOffset() { return dbond_offset; }
  void Preferences::setDoubleBondOffset(double n1) { dbond_offset = n1; }
  int Preferences::getPageWidth() { return paper_width; }
  void Preferences::setPageWidth(int n1) { paper_width = n1; }
  int Preferences::getPageHeight() { return paper_height; }
  void Preferences::setPageHeight(int n1) { paper_height = n1; }
  int Preferences::getUnits() { return units; }
  void Preferences::setUnits(int n1) { units = n1; }
  int Preferences::getGridMode() { return gridmode; }
  void Preferences::setGridMode(int n1) { gridmode = n1; }
  int Preferences::getDrawGrid() { return drawgrid; }
  void Preferences::setDrawGrid(int n1) { drawgrid = n1; }
  int Preferences::getSnapGrid() { return snapgrid; }
  void Preferences::setSnapGrid(int n1) { snapgrid = n1; }
  int Preferences::getGridSpacing() { return gridspace; }
  void Preferences::setGridSpacing(int n1) { gridspace = n1; }
  bool Preferences::getSplash() { return splash; }
  void Preferences::setSplash(bool n1) { splash = n1; }
  int Preferences::getDYKCount() { return dykcount; }
  void Preferences::setDYKCount(int n1) { dykcount = n1; }
  float Preferences::getZoom() { return zoom; }
  void Preferences::setZoom(float z1) { zoom = z1; }
  
  int Preferences::getMagnetic_point_gap() { return magnetic_point_gap; }
  void Preferences::setMagnetic_point_gap(int mag_gap) { magnetic_point_gap=mag_gap; }


  std::string Preferences::get_mono_font(){ return mono_font;}

  std::string Preferences::get_sans_font(){ return sans_font;}

  std::string Preferences::get_serif_font(){ return serif_font;}



  std::string Preferences::get_mono_font_bold(){ return mono_font_bold;}

  std::string Preferences::get_sans_font_bold(){ return sans_font_bold;}

  std::string Preferences::get_serif_font_bold(){ return serif_font_bold;}


  std::string Preferences::get_mono_font_italic(){ return mono_font_italic;}

  std::string Preferences::get_sans_font_italic(){ return sans_font_italic;}

  std::string Preferences::get_serif_font_italic(){ return serif_font_italic;}

  std::string Preferences::get_symbol_font(){ return symbol_font;}

  std::string Preferences::get_dingbats_font(){return dingbats_font;}

  std::string Preferences::get_mono_font_bold_italic(){ return mono_font_bold_italic;}

  std::string Preferences::get_sans_font_bold_italic(){ return sans_font_bold_italic;}

  std::string Preferences::get_serif_font_bold_italic(){ return serif_font_bold_italic;}
