/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-22 20:09
 */
 
#include <string>
#include "PeerAcceptor.h"
#include "log.h"

CPeerAcceptor::CPeerAcceptor()
: _natTimerID(0)
{
}

CPeerAcceptor::~CPeerAcceptor()
{
}

void CPeerAcceptor::setBTTask(IBTTask* task)
{
	_task = task;
}

IBTTask* CPeerAcceptor::getBTTask()
{
	return _task;
}

bool CPeerAcceptor::start()
{
	for(unsigned short i = 7681; i< 7690; ++i)
	{
		createTCPSocket();
		
		if(CSocket::bind(NULL, i))
		{
			_port = i;
			CSocket::listen();
			CSocket::setReactor(_task->getSocketReactor());
			maskRead(true);
			
			_task->getUPnpNat()->addPortMapping(_port, "TCP");
			
			return true;
		}
	}
	return false;
}

void CPeerAcceptor::stop()
{
	if(_natTimerID != 0)
	{
		_task->getSocketReactor()->removeTimer(_natTimerID);
	}
	
	maskRead(false);
	CSocket::setReactor(NULL);
	CSocket::close();
}

int CPeerAcceptor::handleRead()
{
	std::string ip;
	unsigned short port;
	int fd = CSocket::accept(ip, port);
	if(fd != -1)
	{
		//LOG_DEBUG("&&&&&&& accept peer ip="<<ip);
		if(!_task->getPeerManager()->addAcceptedPeer(fd, ip.c_str(), port))
		{
			::close(fd);
		}
	}
	
	return 0;
}

int CPeerAcceptor::handleWrite()
{
	maskWrite(false);
	return 0;
}

void CPeerAcceptor::handleClose()
{
}

unsigned short CPeerAcceptor::getPort()
{
	return _port;
}

