#!/usr/bin/perl

# Copyright (C) 2012-2016  Simon Ruderich
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


use strict;
use warnings;

use Module::Build;


my $build = Module::Build->new(
    module_name        => 'blhc',
    dist_author        => 'Simon Ruderich <simon@ruderich.org>',
    dist_version_from  => 'bin/blhc',
    license            => 'gpl', # gpl_3 is spec 2, not used by Module::Build
    requires           => {
                            # Debian specific (for now).
                            'Dpkg::Arch' => 0,
                            'Dpkg::Version' => 0,
                            # Bundled with perl.
                            'Getopt::Long' => 0,
                            'Pod::Usage' => 0,
                            'Term::ANSIColor' => '2.01',
                            'Text::ParseWords' => 0,
                          },
    configure_requires => {
                            'Module::Build' => 0,
                          },
);
$build->create_build_script;
