/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "headers.h"
#include "SDL/SDL_endian.h"

Pak::Pak()
{
	input = NULL;
}

Pak::~Pak()
{
	if (input != NULL)
		delete input;
		
	input = NULL;
}

void Pak::showPakErrorAndExit()
{
	printf("\nFatal Error: The Blob Wars PAK file was either not found or was not accessable.\n");
	printf("The file was expected to be found within,\n\n");
	printf(PAKFULLPATH"\n\n");
	printf("Please try running the game again. If problems persist either reinstall the game or check,\n\n");
	printf("http://www.parallelrealities.co.uk/blobWars.php\n\n");
	printf("for updates.\n\n");
	exit(1);
}

void Pak::setPakFile(char *pakFilename)
{
	#if USEPAK
	strcpy(this->pakFilename, pakFilename);
	
	debug(("Pak : Filename set to %s\n", pakFilename));

	FILE *pak = fopen(pakFilename, "rb");

	if (!pak)
		showPakErrorAndExit();

	fseek(pak, -sizeof(uLongf), SEEK_END);
	fread(&listPos, sizeof(uLongf), 1, pak);
	fclose(pak);
	
	listPos = SDL_SwapLE32(listPos);
	
	debug(("Pak : File list resides at %d\n", (int)listPos));
	#endif
}

bool Pak::unpack(char *filename, unsigned char **buffer)
{
	debug(("Pak : Unpacking %s...\n", filename));

	FILE *pak = fopen(pakFilename, "rb");
	if (!pak)
		showPakErrorAndExit();

	fseek(pak, listPos, SEEK_SET);

	while (true)
	{
		if (!fread(&fd, sizeof(FileData), 1, pak))
		{
			fclose(pak);
			return false;
		}
		
		fd.cSize = SDL_SwapLE32(fd.cSize);
		fd.fSize = SDL_SwapLE32(fd.fSize);

		if (strcmp(filename, fd.filename) == 0)
		{
			debug(("Found %s. Uncompressing...\n", fd.filename));

			fseek(pak, fd.location, SEEK_SET);

			if (input != NULL)
				delete input;

			input = NULL;

			input = new unsigned char[(int)(fd.cSize * 1.01) + 12];
			*buffer = new unsigned char[fd.fSize];

			fread(input, 1, fd.cSize, pak);

			uncompress(*buffer, &fd.fSize, input, fd.cSize);

			break;
		}
	}

	fclose(pak);

	if (input != NULL)
		delete input;

	input = NULL;
	
	debug(("Pak : Unpack %s...Done\n", filename));

	return true;
}

bool Pak::fileExists(char *filename)
{
	FILE *pak = fopen(pakFilename, "rb");
	if (!pak)
		showPakErrorAndExit();

	fseek(pak, listPos, SEEK_SET);

	while (true)
	{
		if (!fread(&fd, sizeof(FileData), 1, pak))
		{
			fclose(pak);
			return false;
		}

		if (strcmp(filename, fd.filename) == 0)
			break;
	}

	fclose(pak);

	return true;
}

unsigned int Pak::getUncompressedSize()
{
	return (unsigned int)fd.fSize;
}
