/*
Copyright (C) 2004 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "bosses.h"

void createBoss(char *stageName)
{
	return;

	if (strcmp(stageName, "BioMech Supply Depot") == 0)
	{
		Entity *mainBody = getEnemy("BioTankBody");
		Entity *leg1 = getEnemy("BioTankLeg1");
		Entity *leg2 = getEnemy("BioTankLeg2");
		Entity *leg3 = getEnemy("BioTankLeg3");
		Entity *leg4 = getEnemy("BioTankLeg4");

		leg1->owner = leg2->owner = leg3->owner = leg4->owner = mainBody;

		leg1->tx = 0;
		leg1->ty = 0;

		leg2->tx = 25;
		leg2->ty = 0;

		leg3->tx = 50;
		leg3->ty = 0;

		leg4->tx = 75;
		leg4->ty = 0;
	}
}

void doGaldovAI(Entity *galdov)
{
	map.fightingGaldov = true;

	if (SDL_GetTicks() < map.bossNextThink)
		return;

	map.bossNextThink = SDL_GetTicks() + Math::rrand(250, 1500);

	switch (rand() % 4)
	{
		case 0:
			if ((rand() % 5) == 0)
			{
				if (galdov->flags & ENT_FLIES)
					Math::removeBit(&galdov->flags, ENT_FLIES);
				else
					Math::addBit(&galdov->flags, ENT_FLIES);
			}
			break;
		case 1:
			if (galdov->flags & ENT_JUMPS)
				Math::removeBit(&galdov->flags, ENT_JUMPS);
			else
				Math::addBit(&galdov->flags, ENT_JUMPS);
			break;
		case 2:
			galdov->currentWeapon = getRandomGaldovWeapon();
			break;
		case 3:
			if (galdov->flags & ENT_RAPIDFIRE)
				Math::removeBit(&galdov->flags, ENT_RAPIDFIRE);
			else
				Math::addBit(&galdov->flags, ENT_RAPIDFIRE);
			break;
	}
	
	if ((rand() % 25) == 0)
	{
		switch (rand() % 5)
		{
			case 0:
				engine.setInfoMessage("Galdov: Stupid creature!! Give up and join us!", 0, INFO_HINT);
				break;
			case 1:
				engine.setInfoMessage("Galdov: Why do you persist in fighting us?!", 0, INFO_HINT);
				break;
			case 2:
				engine.setInfoMessage("Galdov: And this is the best the Blob Army can offer?", 0, INFO_HINT);
				break;
			case 3:
				engine.setInfoMessage("Galdov: We WILL have the crystals! NOTHING will stop us!!", 0, INFO_HINT);
				break;
			case 4:
				engine.setInfoMessage("Galdov: You're mine now!!!", 0, INFO_HINT);
				break;
		}
	}
}

void doGaldovPlusAI(Entity *galdov)
{
	if (SDL_GetTicks() < map.bossNextThink)
		return;

	map.bossNextThink = SDL_GetTicks() + Math::rrand(250, 1500);

	// Look for a teleport destination...
	
	switch (rand() % 6)
	{
		case 0:
			if ((rand() % 3) == 0)
			{
				if (galdov->flags & ENT_FLIES)
					Math::removeBit(&galdov->flags, ENT_FLIES);
				else
					Math::addBit(&galdov->flags, ENT_FLIES);
			}
			break;
		case 1:
			if (galdov->flags & ENT_JUMPS)
				Math::removeBit(&galdov->flags, ENT_JUMPS);
			else
				Math::addBit(&galdov->flags, ENT_JUMPS);
			break;
		case 2:
			galdov->currentWeapon = getRandomGaldovWeapon();
			break;
		case 3:
			if (galdov->flags & ENT_RAPIDFIRE)
				Math::removeBit(&galdov->flags, ENT_RAPIDFIRE);
			else
				Math::addBit(&galdov->flags, ENT_RAPIDFIRE);
			break;
		case 4:
		case 5:
			if (rand() % 2)
				break;

			int mx = (int)(player.x) >> BRICKSHIFT;
			int my = (int)(player.y) >> BRICKSHIFT;

			mx += Math::rrand(-5, 5);
			my += Math::rrand(-5, 5);

			if ((mx >= 0) && (my >= 0) && (mx < MAPWIDTH) && (my < MAPHEIGHT))
			{
				if (map.data[mx][my] == MAP_AIR)
				{
					if (okayToSpawnEnemy("GaldovPlus", mx, my))
					{
						mx = mx << BRICKSHIFT;
						my = my << BRICKSHIFT;
						galdov->dx = mx;
						galdov->dy = my;
						Math::addBit(&galdov->flags, ENT_TELEPORTING);
						addTeleportParticles(galdov->x + (galdov->width / 2), galdov->y + (galdov->height / 2), 50, SND_TELEPORT3);
						Math::addBit(&galdov->flags, ENT_FLIES);
					}
				}
			}
			break;
	}
}
