/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "mission.h"

void showMissionClear()
{
	int colCount = 7;
	bool perfect = perfectlyCompleted();

	SDL_Surface *clear;

	(perfect) ? clear = graphics.loadImage("gfx/main/areaPerfect.png") : clear = graphics.loadImage("gfx/main/areaClear.png");

	graphics.loadBackground("gfx/main/areaClearBackGround.jpg");

	SDL_Surface *panel = graphics.alphaRect(550, 420, 0x00, 0x00, 0x00);
	SDL_SetAlpha(panel, SDL_SRCALPHA|SDL_RLEACCEL, 180);
	graphics.drawRect(1, 1, panel->w - 2, panel->h - 2 , graphics.black, graphics.white, panel);

	graphics.blit(panel, (640 - panel->w) / 2, (480 - panel->h) / 2, graphics.background, false);

	audio.loadSound(0, "sound/pop.wav");
	audio.loadSound(1, "sound/cheer.wav");

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.updateScreen();

	int y = 520;
	int miaY = 335;
	int clearY = 520;
	Objective *objective = (Objective*)map.objectiveList.getHead();
	Entity *mia = (Entity*)map.miaList.getHead();
	Sprite *teleportStar = graphics.getSprite("TeleportStar", true);
	char message[100];
	int col1 = 310;
	int col2 = 330;
	int count = 0;
	int place = 0;
	int nextStarBurst = 10 * (rand() % 6);

	float px, py, dx, dy;


	while (mia->next != NULL)
	{
		mia = (Entity*)mia->next;

		if (mia->health > 0)
			continue;

		mia->x = 700;
		
		mia->y = miaY;
		
		count++;

		if (count > colCount)
		{
			miaY += 25;
			count = 0;
		}

		place += 25;
	}

	if (count > colCount)
		count = colCount;

	if (place > (colCount * 25))
		place = colCount * 25;

	place = (640 - place) / 2;

	graphics.setFontSize(1);

	graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);

	engine.flushInput();
	engine.clearInput();

	y = 130;
	
	if (map.totalMIAs > 0)
	{
		graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);
		sprintf(message, "%s", engine.translate("Rescue %d MIAs"));
		sprintf(message, message, map.requiredMIAs);
		graphics.drawString(message, col1, y, TXT_RIGHT, graphics.background);

		if (map.foundMIAs < map.requiredMIAs)
		{
			graphics.setFontColor(0xff, 0x00, 0x00, 0x00, 0x00, 0x00);
			sprintf(message, "%d / %d", map.foundMIAs, map.requiredMIAs);
			graphics.drawString(message, col2, y, TXT_LEFT, graphics.background);
		}
		else
		{
			graphics.setFontColor(0x00, 0xff, 0x00, 0x00, 0x00, 0x00);
			graphics.drawString(engine.translate("Completed"), col2, y, TXT_LEFT, graphics.background);
		}
	}

	objective = (Objective*)map.objectiveList.getHead();

	engine.setPlayerPosition(0, 0, -1, -1, -1, -1);

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		y += 20;

		graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);
		graphics.drawString(objective->description, col1, y, TXT_RIGHT, graphics.background);

		if (objective->currentValue < objective->targetValue)
		{
			if (objective->targetValue == 1)
			{
				graphics.setFontColor(0xff, 0x00, 0x00, 0x00, 0x00, 0x00);
				graphics.drawString(engine.translate("Incomplete"), col2, y, TXT_LEFT, graphics.background);
			}
			else
			{
				graphics.setFontColor(0xff, 0x00, 0x00, 0x00, 0x00, 0x00);
				sprintf(message, "%d / %d", objective->currentValue, objective->targetValue);
				graphics.drawString(message, col2, y, TXT_LEFT, graphics.background);
			}
		}
		else
		{
			graphics.setFontColor(0x00, 0xff, 0x00, 0x00, 0x00, 0x00);
			graphics.drawString(engine.translate("Completed"), col2, y, TXT_LEFT, graphics.background);
		}
	}
	
	graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);

	unsigned int frameLimit = SDL_GetTicks() + 16;

	if (perfect)
		audio.playSound(1, 1);

	while (true)
	{
		engine.getInput();
		graphics.updateScreen();
		graphics.animateSprites();

		if (engine.userAccepts())
			break;

		graphics.drawBackground();

		graphics.blit(clear, 320, clearY, graphics.screen, true);

		Math::limitInt(&(clearY -= 5), 70, 520);

		count = 0;

		mia = (Entity*)map.miaList.getHead();

		if (clearY == 70)
		{
			while (mia->next != NULL)
			{
				mia = (Entity*)mia->next;

				if (mia->health > 0)
					continue;

				if (count > colCount)
					count = 0;

				graphics.blit(mia->getFaceImage(), (int)mia->x, (int)mia->y, graphics.screen, false);

				if (mia->x == 700)
					audio.playSound(0, 0);

				if (mia->x > (place + (count * 25)))
					Math::limitFloat(&(mia->x -= 35), place + (count * 25), 640);

				if (mia->x > place + (count * 25))
					break;

				count++;
			}
			
			if (perfect)
			{
				Math::limitInt(&(--nextStarBurst), 0, 999);

				if (nextStarBurst == 0)
				{
					nextStarBurst = 10 * (rand() % 6);

					px = Math::rrand(50, 585);
					py = Math::rrand(55, 85);

					for (int i = 0 ; i < 50 ; i++)
					{
						dx = Math::rrand(-30, 30); dx /= 20;
						dy = Math::rrand(-30, 30); dy /= 20;
						map.addParticle(px, py, dx, dy, Math::rrand(30, 60), graphics.red, teleportStar, PAR_WEIGHTLESS);
					}
				}

				doParticles();
			}
		}

		sprintf(message, "%s - %.2d:%.2d:%.2d", engine.translate("Mission Time"), game.currentMissionHours, game.currentMissionMinutes, game.currentMissionSeconds);
		graphics.drawString(message, 320, 420, true, graphics.screen);

		while (SDL_GetTicks() < frameLimit){}
		frameLimit = SDL_GetTicks() + 16;
	}

	audio.stopMusic();

	saveGame(game.autoSaveSlot);
	
}

