/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "title.h"

void showCheatConfig()
{
	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.delay(500);

	SDL_Surface *header = graphics.getSprite("cheatHeader", true)->image[0];
	SDL_Surface *optionsBackground = graphics.getSprite("optionsBackground", true)->image[0];
	SDL_SetColorKey(optionsBackground, 0, SDL_MapRGB(optionsBackground->format, 0, 0, 0));

	engine.getLocaleInformation("Cheats");

	if (!engine.loadWidgets("data/cheatWidgets"))
		graphics.showErrorAndExit(ERR_FILE, "data/cheatWidgets");
		
	int done = 0;

	engine.setWidgetVariable("health", &engine.cheatHealth);
	engine.setWidgetVariable("extras", &engine.cheatExtras);
	engine.setWidgetVariable("fuel", &engine.cheatFuel);
	engine.setWidgetVariable("rate", &engine.cheatReload);
	engine.setWidgetVariable("jump", &engine.cheatJump);
	engine.setWidgetVariable("invulnerable", &engine.cheatInvulnerable);
	engine.setWidgetVariable("speed", &engine.cheatSpeed);
	engine.setWidgetVariable("levels", &engine.cheatLevels);
	engine.setWidgetVariable("skip", &engine.cheatSkipLevel);
	engine.setWidgetVariable("confirm", &done);
	
	graphics.blit(optionsBackground, 0, 0, graphics.screen, false);
	graphics.blit(header, 320, 25, graphics.screen, true);
	drawWidgets();

	engine.flushInput();
	engine.clearInput();
	
	int menuSound = -1;

	while (!done)
	{
		graphics.updateScreen();
		
		if (menuSound)
			audio.playMenuSound(menuSound);

		engine.getInput();

		menuSound = engine.processWidgets();

		if (menuSound)
		{
			graphics.blit(optionsBackground, 0, 0, graphics.screen, false);
			graphics.blit(header, 320, 25, graphics.screen, true);
			drawWidgets();
		}

		if (engine.keyState[SDLK_ESCAPE])
		{
			engine.clearInput();
			engine.flushInput();
			done = 1;
		}
	}
	
	audio.playMenuSound(2);

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.delay(500);

	engine.getLocaleInformation("Options");

	if (!engine.loadWidgets("data/optionWidgets"))
		graphics.showErrorAndExit(ERR_FILE, "data/optionWidgets");
}

void showJoystickConfig()
{
	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.delay(500);

	engine.getLocaleInformation("Joystick");

	if (!engine.loadWidgets("data/joystickWidgets"))
		graphics.showErrorAndExit(ERR_FILE, "data/joystickWidgets");
		
	SDL_Surface *header = graphics.getSprite("joystickHeader", true)->image[0];
	SDL_Surface *optionsBackground = graphics.getSprite("optionsBackground", true)->image[0];
	SDL_SetColorKey(optionsBackground, 0, SDL_MapRGB(optionsBackground->format, 0, 0, 0));

	int done = 0;

	engine.setWidgetVariable("left", &engine.joypad.left);
	engine.setWidgetVariable("right", &engine.joypad.right);
	engine.setWidgetVariable("up", &engine.joypad.up);
	engine.setWidgetVariable("down", &engine.joypad.down);
	engine.setWidgetVariable("fire", &engine.joypad.fire);
	engine.setWidgetVariable("jump", &engine.joypad.jump);
	engine.setWidgetVariable("pause", &engine.joypad.pause);

	engine.setWidgetVariable("jetpack", &engine.joypad.jetpack);
	engine.setWidgetVariable("map", &engine.joypad.map);

	engine.setWidgetVariable("confirm", &done);
	
	graphics.blit(optionsBackground, 0, 0, graphics.screen, false);
	graphics.blit(header, 320, 25, graphics.screen, true);
	drawWidgets();

	engine.flushInput();
	engine.clearInput();
	
	int menuSound = -1;
	
	engine.allowJoypad = false;

	while (!done)
	{
		graphics.updateScreen();
		
		if (menuSound)
			audio.playMenuSound(menuSound);

		engine.getInput();

		menuSound = engine.processWidgets();

		graphics.blit(optionsBackground, 0, 0, graphics.screen, false);
		graphics.blit(header, 320, 25, graphics.screen, true);
		drawWidgets();

		if (engine.keyState[SDLK_ESCAPE])
		{
			engine.clearInput();
			engine.flushInput();
			done = 1;
		}
	}
	
	engine.allowJoypad = true;
	
	engine.saveJoystickConfig();

	audio.playMenuSound(2);

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.delay(500);

	engine.getLocaleInformation("Options");

	if (!engine.loadWidgets("data/optionWidgets"))
		graphics.showErrorAndExit(ERR_FILE, "data/optionWidgets");
}

void showOptions()
{
	float brightness;

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.delay(500);

	engine.getLocaleInformation("Options");

	if (!engine.loadWidgets("data/optionWidgets"))
		graphics.showErrorAndExit(ERR_FILE, "data/optionWidgets");
		
	SDL_Surface *header = graphics.getSprite("optionsHeader", true)->image[0];
	SDL_Surface *optionsBackground = graphics.getSprite("optionsBackground", true)->image[0];
	SDL_SetColorKey(optionsBackground, 0, SDL_MapRGB(optionsBackground->format, 0, 0, 0));

	int done = 0;
	int joysticks = 0;
	int cheats = 0;

	engine.setWidgetVariable("fullscreen", &engine.fullScreen);
	engine.setWidgetVariable("soundvol", &game.soundVol);
	engine.setWidgetVariable("musicvol", &game.musicVol);
	engine.setWidgetVariable("output", &game.output);
	engine.setWidgetVariable("saveslot", &game.autoSaveSlot);
	engine.setWidgetVariable("gamma", &game.brightness);
	engine.setWidgetVariable("gore", &game.gore);
	engine.setWidgetVariable("joysticks", &joysticks);
	engine.setWidgetVariable("cheats", &cheats);
	engine.setWidgetVariable("confirm", &done);

	if (!engine.useAudio)
	{
		engine.enableWidget("soundvol", false);
		engine.enableWidget("musicvol", false);
		engine.enableWidget("output", false);
	}

	if (SDL_NumJoysticks() == 0)
		engine.enableWidget("joysticks", false);

	engine.showWidget("cheats", engine.cheats);

	graphics.blit(optionsBackground, 0, 0, graphics.screen, false);
	graphics.blit(header, 320, 25, graphics.screen, true);
	drawWidgets();

	engine.flushInput();
	engine.clearInput();
	
	int menuSound = -1;

	while (!done)
	{
		graphics.updateScreen();
		
		if (menuSound)
			audio.playMenuSound(menuSound);

		engine.getInput();

		if (engine.compareLastKeyInputs())
		{
			if (engine.cheats)
			{
				audio.playSound(SND_CHEAT, CH_ANY);
				engine.clearCheatVars();
			}

			engine.showWidget("cheats", engine.cheats);
			drawWidgets();
		}
		
		menuSound = engine.processWidgets();

		if (menuSound)
		{
			if (engine.widgetChanged("soundvol"))
				audio.setSoundVolume(game.soundVol);

			if (engine.widgetChanged("musicvol"))
				audio.setMusicVolume(game.musicVol);

			if (engine.widgetChanged("fullscreen"))
				SDL_WM_ToggleFullScreen(graphics.screen);

			if (engine.widgetChanged("gamma"))
			{
				brightness = game.brightness;
				brightness /= 10;
				SDL_SetGamma(brightness, brightness, brightness);
			}
			
			if ((engine.widgetChanged("joysticks")) || (engine.widgetChanged("cheats")))
			{
				audio.playMenuSound(2);
				menuSound = 0;

				if (engine.widgetChanged("joysticks"))
					showJoystickConfig();

				if (engine.widgetChanged("cheats"))
					showCheatConfig();

				engine.setWidgetVariable("fullscreen", &engine.fullScreen);
				engine.setWidgetVariable("soundvol", &game.soundVol);
				engine.setWidgetVariable("musicvol", &game.musicVol);
				engine.setWidgetVariable("output", &game.output);
				engine.setWidgetVariable("saveslot", &game.autoSaveSlot);
				engine.setWidgetVariable("gamma", &game.brightness);
				engine.setWidgetVariable("gore", &game.gore);
				engine.setWidgetVariable("joysticks", &joysticks);
				engine.setWidgetVariable("cheats", &cheats);
				engine.setWidgetVariable("confirm", &done);

				if (!engine.useAudio)
				{
					engine.enableWidget("soundvol", false);
					engine.enableWidget("musicvol", false);
					engine.enableWidget("output", false);
				}
				
				if (SDL_NumJoysticks() == 0)
					engine.enableWidget("joysticks", false);
			}

			graphics.blit(optionsBackground, 0, 0, graphics.screen, false);
			graphics.blit(header, 320, 25, graphics.screen, true);
			drawWidgets();
		}

		if (engine.keyState[SDLK_ESCAPE])
		{
			engine.clearInput();
			engine.flushInput();
			done = 1;
		}
	}

	audio.playMenuSound(2);

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.delay(500);
}

void showSkillLevels()
{
	engine.showWidgetGroup("skill", true);
	engine.showWidgetGroup("mainMenu", false);

	engine.showWidget("back", true);

	engine.highlightWidget("normal");
	engine.enableWidget("extreme", false);
}

void showSaves()
{
	engine.showWidgetGroup("saveGames", true);
	engine.showWidgetGroup("mainMenu", false);

	engine.showWidget("back", true);

	engine.highlightWidget("save1");
}

void showManualHelp()
{
	engine.showWidgetGroup("help", true);
	engine.showWidgetGroup("mainMenu", false);
	
	engine.showWidget("back", true);

	engine.highlightWidget("back");
}

void showTitleWidgets()
{
	engine.showWidgetGroup("skill", false);
	engine.showWidgetGroup("saveGames", false);
	engine.showWidgetGroup("help", false);
	engine.showWidgetGroup("mainMenu", true);

	engine.showWidget("back", false);

	if (!engine.continueSaveSlot)
	{
		engine.enableWidget("loadGame", false);
		engine.enableWidget("continue", false);
	}

	engine.highlightWidget("newGame");
}

void setupSaveWidgets()
{
	strcpy(engine.getWidgetByName("save1")->label, engine.saveSlot[0]);
	strcpy(engine.getWidgetByName("save2")->label, engine.saveSlot[1]);
	strcpy(engine.getWidgetByName("save3")->label, engine.saveSlot[2]);
	strcpy(engine.getWidgetByName("save4")->label, engine.saveSlot[3]);
	strcpy(engine.getWidgetByName("save5")->label, engine.saveSlot[4]);

	if ((strstr(engine.saveSlot[0], "Empty")) || (strstr(engine.saveSlot[0], "Corrupt")))
		engine.enableWidget("save1", false);

	if ((strstr(engine.saveSlot[1], "Empty")) || (strstr(engine.saveSlot[1], "Corrupt")))
		engine.enableWidget("save2", false);

	if ((strstr(engine.saveSlot[2], "Empty")) || (strstr(engine.saveSlot[2], "Corrupt")))
		engine.enableWidget("save3", false);

	if ((strstr(engine.saveSlot[3], "Empty")) || (strstr(engine.saveSlot[3], "Corrupt")))
		engine.enableWidget("save4", false);

	if ((strstr(engine.saveSlot[4], "Empty")) || (strstr(engine.saveSlot[4], "Corrupt")))
		engine.enableWidget("save5", false);
}

void loadTitleWidgets()
{
	engine.getLocaleInformation("Title");

	if (!engine.loadWidgets("data/titleWidgets"))
		graphics.showErrorAndExit(ERR_FILE, "data/titleWidgets");

	initSaveSlots();

	setupSaveWidgets();
	
	Widget *widget = engine.getWidgetByName("labelManual");
	strcpy(widget->label, GAMEPLAYMANUAL);

	showTitleWidgets();
}

int title()
{
	audio.free();
	graphics.free();

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.delay(1000);

	newGame();

	loadTitleWidgets();

	float backAlpha = 0;
	float titleAlpha = 0;
	bool allFadedOn = false;

	graphics.quickSprite("cheatHeader", graphics.loadImage("gfx/main/cheats.png"));
	graphics.quickSprite("optionsHeader", graphics.loadImage("gfx/main/options.png"));
	graphics.quickSprite("joystickHeader", graphics.loadImage("gfx/main/joystickConfig.png"));
	graphics.quickSprite("optionsBackground", graphics.loadImage("gfx/main/optionsBackground.png"));

	SDL_Surface *prlogo = graphics.quickSprite("PRLogo", graphics.loadImage("gfx/main/prlogo.gif"));
	SDL_Surface *title = graphics.quickSprite("Title", graphics.loadImage("gfx/main/title.png"));
	
	graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);

	graphics.setFontSize(3);
	SDL_Surface *presents = graphics.quickSprite("Presents", graphics.getString(engine.translate("Presents"), true));
	SDL_Surface *sdl = graphics.quickSprite("SDL", graphics.getString(engine.translate("An SDL Game"), true));

	graphics.setFontSize(2);
	SDL_Surface *subTitle = graphics.quickSprite("SubTitle", graphics.getString(engine.translate("Blob Wars : Episode I"), true));

	graphics.setFontSize(0);
	SDL_Surface *copyright = graphics.quickSprite("Copyright", graphics.getString("Copyright (C) 2004 Parallel Realities", true));

	char v[50];
	sprintf(v, "Version %.1f", VERSION);
	SDL_Surface *version = graphics.quickSprite("Version", graphics.getString(v, true));

	SDL_SetAlpha(title, SDL_SRCALPHA|SDL_RLEACCEL, 0);

	audio.loadMusic("music/helmet-shake.mod");

	graphics.loadBackground("gfx/main/circuit.png");
	SDL_SetAlpha(graphics.background, SDL_SRCALPHA|SDL_RLEACCEL, 0);

	int startNewGame, options, quit, help, easy, normal, hard, extreme, back, practice;
	int load, cont, save[5];

	startNewGame = options = quit = easy = normal = hard = extreme = back = help = practice = 0;
	load = cont = save[0] = save[1] = save[2] = save[3] = save[4] = 0;

	engine.setWidgetVariable("newGame", &startNewGame);
	engine.setWidgetVariable("loadGame", &load);
	engine.setWidgetVariable("continue", &cont);
	engine.setWidgetVariable("options", &options);
	engine.setWidgetVariable("help", &help);
	engine.setWidgetVariable("quit", &quit);

	float offX = 0;

	engine.flushInput();
	engine.clearInput();

	audio.playMusic();

	Uint32 now = SDL_GetTicks();

	unsigned int frameLimit = SDL_GetTicks() + 16;

	while (true)
	{
		graphics.updateScreen();

		engine.getInput();

		for (int x = (int)offX ; x < 640 ; x += graphics.background->w)
		{
			for (int y = 0 ; y < 480 ; y += graphics.background->h)
			{
				graphics.blit(graphics.background, x, y, graphics.screen, false);
			}
		}

		if (!allFadedOn)
		{
			if ((SDL_GetTicks() >= now + 2000) && (SDL_GetTicks() <= now + 10000))
			{
				graphics.blit(prlogo, 320, 240, graphics.screen, true);
			}
			else if ((SDL_GetTicks() >= now + 13000) && (SDL_GetTicks() <= now + 19000))
			{
				graphics.blit(presents, 320, 240, graphics.screen, true);
			}
			else if ((SDL_GetTicks() >= now + 22000) && (SDL_GetTicks() <= now + 27000))
			{
				graphics.blit(sdl, 320, 240, graphics.screen, true);
			}

			if (engine.userAccepts())
			{
				allFadedOn = true;
				engine.flushInput();
				engine.clearInput();
				backAlpha = 255;
				titleAlpha = 255;
				SDL_SetAlpha(graphics.background, SDL_SRCALPHA|SDL_RLEACCEL, (int)backAlpha);
				SDL_SetAlpha(title, SDL_SRCALPHA|SDL_RLEACCEL, (int)titleAlpha);
			}
		}

		if ((SDL_GetTicks() >= now + 4000) || (allFadedOn))
		{
			if (backAlpha < 255)
			{
				backAlpha++;
				SDL_SetAlpha(graphics.background, SDL_SRCALPHA|SDL_RLEACCEL, (int)backAlpha);
			}
		}

		if ((SDL_GetTicks() >= now + 29000) || (allFadedOn))
		{
			if (titleAlpha < 255)
			{
				titleAlpha++;
				SDL_SetAlpha(title, SDL_SRCALPHA|SDL_RLEACCEL, (int)titleAlpha);
			}
			else
			{
				graphics.blit(subTitle, 320, 180, graphics.screen, true);
				graphics.blit(copyright, 10, 460, graphics.screen, false);
				graphics.blit(version, (630 - version->w), 460, graphics.screen, false);
				allFadedOn = true;
			}
		}

		Math::wrapFloat(&(offX -= 0.25), -graphics.background->w, 0);

		if (backAlpha > 0)
			graphics.blit(title, 320, 100, graphics.screen, true);

		if (allFadedOn)
		{
			drawWidgets();
			audio.playMenuSound(engine.processWidgets());
		}

		if (options)
		{
			showOptions();
			loadTitleWidgets();
			engine.setWidgetVariable("newGame", &startNewGame);
			engine.setWidgetVariable("loadGame", &load);
			engine.setWidgetVariable("continue", &cont);
			engine.setWidgetVariable("options", &options);
			engine.setWidgetVariable("help", &help);
			engine.setWidgetVariable("quit", &quit);
			options = 0;
			engine.flushInput();
		}

		if (help)
		{
			showManualHelp();
			engine.setWidgetVariable("back", &back);
			help = 0;
		}

		if (startNewGame)
		{
			showSkillLevels();
			engine.setWidgetVariable("practice", &practice);
			engine.setWidgetVariable("easy", &easy);
			engine.setWidgetVariable("normal", &normal);
			engine.setWidgetVariable("hard", &hard);
			engine.setWidgetVariable("extreme", &extreme);
			engine.setWidgetVariable("back", &back);
			startNewGame = 0;
		}

		if (load)
		{
			showSaves();
			engine.setWidgetVariable("save1", &save[0]);
			engine.setWidgetVariable("save2", &save[1]);
			engine.setWidgetVariable("save3", &save[2]);
			engine.setWidgetVariable("save4", &save[3]);
			engine.setWidgetVariable("save5", &save[4]);
			engine.setWidgetVariable("back", &back);
			load = 0;
		}

		if (easy) {engine.skill = 0; break;}
		if (normal) {engine.skill = 1; break;}
		if (hard) {engine.skill = 2; break;}
		if (extreme) {engine.skill = 3; break;}
		if (practice) {engine.skill = -1; break;}

		if (cont) {load = engine.continueSaveSlot; break;}

		if (save[0]) {load = 1; break;}
		if (save[1]) {load = 2; break;}
		if (save[2]) {load = 3; break;}
		if (save[3]) {load = 4; break;}
		if (save[4]) {load = 5; break;}

		if (engine.keyState[SDLK_ESCAPE])
		{
			audio.playMenuSound(2);
			back = 1;
			engine.clearInput();
			engine.flushInput();
		}

		if (back) {showTitleWidgets(); back = 0;}

		if (quit)
			break;

		while (SDL_GetTicks() < (frameLimit)){}
		frameLimit = SDL_GetTicks()  + 16;
	}

	engine.deleteWidgets();

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.updateScreen();
	audio.stopMusic();
	
	if (quit)
	{
		if (engine.useAudio)
			SDL_Delay(1000);
		exit(0);
	}

	newGame();

	if (load)
		loadGame(load - 1);
		
	if (engine.skill == -1)
	{
		game.setMapName("data/practice");
		game.setStageName("Training Mission");
		return SECTION_GAME;
	}

	return SECTION_HUB;
}

void doCredits()
{
	map.clear();

	char *line;
	char string[100];
	int i = 0;
	int numberOfCredits = 0;
	int pos1 = 0, pos2 = 0, size = 0;
	float *y;

	SDL_Surface *backdrop = graphics.quickSprite("CreditsBackGround", graphics.loadImage("gfx/main/creditsBack.png"));

	engine.loadData("data/credits");

	line = strtok((char*)engine.dataBuffer, "\n");

	sscanf(line, "%d", &numberOfCredits);

	y = new float[numberOfCredits];
	SDL_Surface *credit[numberOfCredits];

	line = strtok(NULL, "\n");

	pos1 = 520;

	graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);

	while (line)
	{
		sscanf(line, "%d %d %[^\n]", &pos2, &size, string);

		pos1 += pos2;

		y[i] = pos1;

		graphics.setFontSize(size);
		credit[i] = graphics.quickSprite("credit", graphics.getString(string, true));

		i++;

		if (i == numberOfCredits)
			break;

		line = strtok(NULL, "\n");
	}

	audio.loadMusic("music/autumnsDawning.s3m");
	audio.playMusic();

	engine.resetTimeDifference();

	while (y[numberOfCredits - 1] > 350)
	{
		graphics.updateScreen();
		engine.getInput();

		engine.doTimeDifference();

		SDL_FillRect(graphics.screen, NULL, graphics.black);
		graphics.blit(backdrop, 0, 365, graphics.screen, false);

		for (i = 0 ; i < numberOfCredits ; i++)
		{
			y[i] -= (0.25 * engine.getTimeDifference());
			if ((y[i] > 10) && (y[i] < 470))
				graphics.blit(credit[i], 320, (int)y[i], graphics.screen, true);

			graphics.drawRect(0, 450, 640, 30, graphics.black, graphics.screen);
			graphics.drawRect(0, 0, 640, 30, graphics.black, graphics.screen);
		}
	}

	graphics.delay(5000);
	audio.fadeMusic();
	graphics.fadeToBlack();

	delete y;
}
