/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "trains.h"

void openDoor(Train *train)
{
	if (train->active)
		return;

	switch (train->type)
	{
		case TR_GOLD_DOOR:
		case TR_GOLD_SLIDEDOOR:
			engine.setInfoMessage(engine.translate("Used Gold Key"), 1, INFO_NORMAL);
			break;
		case TR_SILVER_DOOR:
		case TR_SILVER_SLIDEDOOR:
			engine.setInfoMessage(engine.translate("Used Silver Key"), 1, INFO_NORMAL);
			break;
		case TR_BRONZE_DOOR:
		case TR_BRONZE_SLIDEDOOR:
			engine.setInfoMessage(engine.translate("Used Bronze Key"), 1, INFO_NORMAL);
			break;
	}

	if ((train->type != TR_LOCKED_DOOR) && (train->type != TR_LOCKED_SLIDEDOOR))
	{
		if (train->type < TR_SLIDEDOOR)
			train->type = TR_DOOR;
		else
			train->type = TR_SLIDEDOOR;
	}

	train->active = true;

	audio.playSound(SND_OPENDOOR, CH_TOUCH);
}

void trainBlockEntity(Entity *ent, char *message, Train *train, int dir)
{
	if (ent == &player)
	{
		if ((train->isReady()) && (!train->active))
		{
			engine.setInfoMessage(engine.translate(message), 1, INFO_NORMAL);
			audio.playSound(SND_LOCKEDDOOR, CH_TOUCH);
		}
	}
	
	if ((dir == 0) && (ent->flags & ENT_BULLET))
	{
		if (ent->dx < 0) ent->x = train->x + train->sprite->image[0]->w;
		if (ent->dx > 0) ent->x = train->x - ent->width;
	}

	if (dir == 1)
	{
		if ((ent->dy >= 0) && (train->type >= TR_SLIDEDOOR))
		{
			ent->dy = 0;
			ent->falling = false;
		}
	}
}

bool checkTrainContact(Entity *ent, int dir)
{
	Train *train = (Train*)map.trainList.getHead();

	bool collision = false;
	int x, y, mapAttribute;

	while (train->next != NULL)
	{
		train = (Train*)train->next;

		if (dir == 0)
			collision = (Collision::collision(ent->x + ent->dx, ent->y, ent->width, ent->height - 1, train->x, train->y, train->width, train->height));
		else
			collision = (Collision::collision(ent->x, ent->y + ent->dy, ent->width, ent->height - 1, train->x, train->y, train->width, train->height));

		if (collision)
		{
			switch (train->type)
			{
				case TR_TRAIN:
					if (ent->flags & ENT_BULLET)
						return true;
					if (ent->flags & ENT_FLIES)
						return false;

					if ((ent == &player) && (train->waitsForPlayer()))
						train->active = true;

					x = (int)(ent->x + ent->dx) >> BRICKSHIFT;
					y = (int)(ent->y + ent->height - 1) >> BRICKSHIFT;

					mapAttribute = map.data[x][y];

					evaluateMapAttribute(ent, mapAttribute);

					if (ent->dy >= 0)
					{
						if (train->active)
							ent->x -= train->getDX();

						ent->dy = 1;

						ent->y = train->y;
						ent->y -= ent->height;

						ent->falling = false;
					}

					break;

				case TR_DOOR:
				case TR_SLIDEDOOR:
					if (!(ent->flags & ENT_BULLET))
						openDoor(train);
					if (dir == 1)
					{
						ent->dy = 0;
						ent->falling = false;
					}
					return true;
					break;

				case TR_LOCKED_DOOR:
				case TR_LOCKED_SLIDEDOOR:
					trainBlockEntity(ent, "Door is locked", train, dir);
					return true;
					break;

				case TR_GOLD_DOOR:
				case TR_GOLD_SLIDEDOOR:
					if ((ent == &player) && (carryingItem("Gold Key")))
						openDoor(train);
					else
						trainBlockEntity(ent, "Gold Key Required", train, dir);
					return true;
					break;

				case TR_SILVER_DOOR:
				case TR_SILVER_SLIDEDOOR:
					if ((ent == &player) && (carryingItem("Silver Key")))
						openDoor(train);
					else
						trainBlockEntity(ent, "Silver Key Required", train, dir);
					return true;
					break;

				case TR_BRONZE_DOOR:
				case TR_BRONZE_SLIDEDOOR:
					if ((ent == &player) && (carryingItem("Bronze Key")))
						openDoor(train);
					else
						trainBlockEntity(ent, "Bronze Key Required", train, dir);
					return true;
					break;
			}
		}
	}

	return false;
}

void doTrains()
{
	Train *train = (Train*)map.trainList.getHead();

	int x, y;

	while (train->next != NULL)
	{
		train = (Train*)train->next;

		x = (int)(train->x - engine.playerPosX);
		y = (int)(train->y - engine.playerPosY);

		if ((train->type == TR_TRAIN) && (train->active))
			train->move();

		if (train->type != TR_TRAIN)
		{
			if (train->openClose())
				audio.playSound(SND_DOOROPENED, CH_TOUCH);
		}

		if (train->sprite == NULL)
		{
			if (train->type == TR_TRAIN)
				train->sprite = graphics.getSprite("Platform", true);
			else if ((train->type >= TR_DOOR) && (train->type < TR_SLIDEDOOR))
				train->sprite = graphics.getSprite("NormalDoor", true);
			else
				train->sprite = graphics.getSprite("SlideDoor", true);
		}

		if ((abs(x) <= 800) && (abs(y) <= 600))
			graphics.blit(train->sprite->getCurrentFrame(), x, y, graphics.screen, false);
	}
}
