# -*- coding: utf-8 -*-

#  Bluemindo
#  lastfm.py

#    Bluemindo: A really simple but powerful audio player in Python/PyGTK.
#    Copyright (C) 2007-2008  Erwan Briand

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation version 3 of the License.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from gtk import WIN_POS_CENTER_ALWAYS
from thread import start_new_thread
from base64 import b64decode, b64encode
from gtk.glade import XML as glade_XML
from os.path import join, isdir, isfile, expanduser
from os import makedirs, chmod
from time import strftime, gmtime
import ConfigParser

from libs.audioscrobbler import AudioScrobblerPost
from common.config import ConfigLoader

class Lastfm:
    def __init__(self, plugin):
        self.plugin = {'name': 'Last.fm',
                       'version': 0.1,
                       'logo': 'plugins/lastfm/lastfm_small.png',
                       'configurable': True,
                       'authors': 'Erwan Briand <erwan@codingteam.net>',
                       'license': 'GNU General Public License 3',
                       'description': _('Send current song to Last.fm profile')}

        plugin.connect('OnModuleConfiguration', self.loadconfig)
        plugin.connect('OnModuleConfigurationSave', self.saveconfig)
        plugin.connect('OnPlayNewSong', self.handler_play_new_song)
        
        config = ConfigLoader()
        self.plugin_conf = join(config.confdir, 'plugins', 'lastfm')
        if not isdir(self.plugin_conf):
            makedirs(self.plugin_conf)

        self.configfile = ConfigParser.ConfigParser()
        self.configfile_ = self.plugin['name'] + '.cfg'

    def handler_play_new_song(self, song):
        start_new_thread(self.lasfm_query, (song[1], song[2], song[3], song[7]))

    def lasfm_query(self, title, artist, album, length):
        try:
            self.configfile.read(join(self.plugin_conf, self.configfile_))
            form0 = self.configfile.get(self.plugin['name'], 'username')
            form1 = self.configfile.get(self.plugin['name'], 'password')
            file_exist = True
        except:
            file_exist = False

        if file_exist and not form0 == '' and not form1 == '':
            datetime = strftime("%Y-%m-%d %H:%M:%S", gmtime())
            
            track = dict(
                            artist_name = artist,
                            song_title = title,
                            length = length,
                            date_played = datetime,
                            album = album,
                            mbid = ''
                        )

            post = AudioScrobblerPost(form0, b64decode(form1))
            post(**track)

    # This function shows the configuration and interface
    def loadconfig(self, (plugin, confglade)):
        if plugin == self.plugin['name']:
            # Load the glade and put the vertical box in the plugin's
            # configuration one
            self.conf_widgets = glade_XML('plugins/lastfm/configuration.glade',
                                          'vbox1', domain='bluemindo')

            hbox = confglade.get_widget('hbox2')

            try:
                kids = hbox.get_children()
                hbox.remove(kids[2])
            except:
                pass

            hbox.add(self.conf_widgets.get_widget('vbox1'))

            try:
                self.configfile.read(join(self.plugin_conf, self.configfile_))
                form0 = self.configfile.get(self.plugin['name'], 'username')
                form1 = self.configfile.get(self.plugin['name'], 'password')

                file_exist = True
            except:
                file_exist = False

            if file_exist:
                self.conf_widgets.get_widget('entry1').set_text(form0)
                self.conf_widgets.get_widget('entry2').set_text(b64decode(form1))

    # This function saves the configuration
    def saveconfig(self, extension):
        if extension == self.plugin['name']:
            try:
                field0 = self.conf_widgets.get_widget('entry1')
                field1 = self.conf_widgets.get_widget('entry2')
                widgets_retrieved = True
            except:
                widgets_retrieved = False

            if widgets_retrieved:
                try:
                    self.configfile.add_section(self.plugin['name'])
                except:
                    pass

                form0 = field0.get_text()
                form1 = field1.get_text()

                self.configfile.set(self.plugin['name'], 'username', form0)
                self.configfile.set(self.plugin['name'],
                                    'password', b64encode(form1))

                self.configfile.write(open(join(self.plugin_conf,
                                                self.configfile_), 'w'))
                chmod(join(self.plugin_conf, self.configfile_), 0600)
