/*
*
*  A2DPD - Bluetooth A2DP daemon for Linux
*
*  Copyright (C) 2006-2007  Frédéric DALLEAU <frederic.dalleau@palmsource.com>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __SCO_LIB_H__
#define __SCO_LIB_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include "a2dpd_ipc.h"

typedef struct sco* LPSCO;

// Global library initialisation
extern void sco_init( void);
extern void sco_exit( void);

// Connect to sco
extern LPSCO sco_new( char* device);
extern void sco_destroy( LPSCO *sco);
extern int sco_state_connect( LPSCO sco);
extern int sco_is_connecting(LPSCO sco);
extern int sco_is_connected(LPSCO sco);
extern void sco_state_disconnect(LPSCO sco);
extern void sco_state_startstream(LPSCO sco);
extern void sco_state_suspend(LPSCO sco);

// Transfers data
extern int sco_transfer_raw( LPSCO sco, const char* pcm_buffer, int pcm_buffer_size);
extern void sco_add_fd_to_poll(LPSCO sco, struct pollinfo* pollinfos);
extern int sco_state_machine(LPSCO sco, char* lpFrame, size_t iSize, ssize_t* received);

// Control connection
extern void sco_set_dst_addr(LPSCO sco, char* bdaddr);

#endif
