#include <gtkmm.h>
#include <mcs/types.h>
#include <mcs/key.h>
#include <mcs/mcs.h>
#include <mcs/gtk-bind.h>

namespace Mcs
{
	Bind::Bind (Mcs::Mcs * mcs) : mcs (mcs) {}

	Bind::~Bind () {}

	//Gtk::Range
	void
	Bind::range_value_changed (Gtk::Range     	  * range,
                             std::string const&   domain,
                             std::string const&   key)
	{
	    KeyVariant key_value = int (range->get_value());
	    mcs->key_set (domain, key, key_value);
	}
	void
	Bind::bind_range         (Gtk::Range    	   *  range,
                  				  std::string const&	  domain,
                  				  std::string const&	  key)
	{
	    range->signal_value_changed().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::range_value_changed), range, domain, key));
	    range->set_value (double(mcs->key_get<int>(domain, key)));
	}	

	//Gtk::SpinButton 
	void
	Bind::spin_button_changed_cb (Gtk::SpinButton	    * spin_button,
                  				      std::string const&    domain,
                  				      std::string const&    key)
	{
	    KeyVariant key_value = spin_button->get_value_as_int ();
	    mcs->key_set (domain, key, key_value);
	}
	void
	Bind::bind_spin_button   (Gtk::SpinButton	       *  spin_button,
                      		  std::string const&	      domain,
                  				  std::string const&	      key)
	{
	    spin_button->signal_value_changed().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::spin_button_changed_cb), spin_button, domain, key));
	    spin_button->set_value (double(mcs->key_get<int>(domain, key)));
	}	

	//Gtk::Entry 
	void
	Bind::entry_changed_cb (Gtk::Entry	        * entry,
            			        std::string const&    domain,
			                    std::string const&    key)
	{
	    KeyVariant key_value = std::string (entry->get_text ()); 
	    mcs->key_set (domain, key, key_value);
	}
	void
	Bind::bind_entry   (Gtk::Entry	      * entry,
             			    std::string const&  domain,
             			    std::string const&  key)
	{
	    entry->signal_changed().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::entry_changed_cb), entry, domain, key));
	    entry->set_text (mcs->key_get<std::string>(domain, key));
	}	

	//Gtk::ToggleAction 
	void
	Bind::action_toggled_cb (Glib::RefPtr<Gtk::ToggleAction>  toggle_action,
                           std::string const&               domain,
                           std::string const&               key)
	{
	    KeyVariant key_value = toggle_action->get_active (); 
	    mcs->key_set (domain, key, key_value);
	}
	void
	Bind::bind_toggle_action (Glib::RefPtr<Gtk::ToggleAction> toggle_action,
                            std::string const&	            domain,
                            std::string const&              key)
	{
	    toggle_action->signal_toggled().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::action_toggled_cb), toggle_action, domain, key));
	    toggle_action->set_active (mcs->key_get<bool>(domain, key));
	}	

	//Gtk::ToggleButton 
	void
	Bind::button_toggled_cb (Gtk::ToggleButton   *  toggle_button,
                           std::string const&     domain,
                           std::string const&     key)
	{
	    KeyVariant key_value = toggle_button->get_active (); 
	    mcs->key_set (domain, key, key_value);
	}
	void
	Bind::bind_toggle_button (Gtk::ToggleButton   * toggle_button,
                            std::string const&	  domain,
                            std::string const&	  key)
	{
	    toggle_button->signal_toggled().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::button_toggled_cb), toggle_button, domain, key));
	    toggle_button->set_active (mcs->key_get<bool>(domain, key));
	}	

	//Gtk::FileChooser
	void
	Bind::fc_current_folder_set (Gtk::FileChooser     * filechooser,
                               std::string const&     domain,
                               std::string const&     key)
	{
	    KeyVariant key_value = std::string (Glib::filename_from_uri (filechooser->get_current_folder_uri()));
	    mcs->key_set (domain, key, key_value);
	}
	void
	Bind::bind_filechooser (Gtk::FileChooser   * filechooser,
                          std::string const&   domain,
                          std::string const&   key)
	{
	    filechooser->signal_current_folder_changed().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::fc_current_folder_set), filechooser, domain, key));
	    filechooser->set_current_folder_uri (Glib::filename_to_uri (mcs->key_get<std::string>(domain, key)));
	}	

	//Gtk::FontButton 
	void
	Bind::font_set_cb      (Gtk::FontButton     * font_button,
                          std::string const&    domain,
                          std::string const&    key)
	{
	    KeyVariant key_value = std::string(font_button->get_font_name ()); 
	    mcs->key_set (domain, key, key_value);
	}
	void
	Bind::bind_font_button (Gtk::FontButton     * font_button,
                          std::string const&    domain,
                          std::string const&    key)
	{
	    font_button->signal_font_set().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::font_set_cb), font_button, domain, key));
	    font_button->property_font_name() = mcs->key_get<std::string>(domain, key);
	}	

	//Gtk::ComboBoxEntry 
	void
	Bind::cbox_entry_changed_cb (Gtk::ComboBoxEntry  *  cbox_entry,
                               std::string const&     domain,
                               std::string const&     key)
	{
	    KeyVariant key_value = std::string(cbox_entry->get_entry()->get_text ()); 
	    mcs->key_set (domain, key, key_value);
	}

	void
	Bind::bind_cbox_entry 	(Gtk::ComboBoxEntry  *  cbox_entry,
                           std::string const&     domain,
                           std::string const&     key)
	{
	    cbox_entry->get_entry()->set_text (mcs->key_get<std::string>(domain, key));
	    cbox_entry->signal_changed().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::cbox_entry_changed_cb), cbox_entry, domain, key));
	}

	//Gtk::ComboBox 
	void
	Bind::cbox_changed_cb       (Gtk::ComboBox       *  cbox,
                               std::string const&     domain,
                               std::string const&     key)
	{
	    KeyVariant key_value = int(cbox->get_active_row_number());
	    mcs->key_set (domain, key, key_value);
	}

	void
	Bind::bind_cbox       	(Gtk::ComboBox       *  cbox,
                           std::string const&     domain,
                           std::string const&     key)
	{
	    cbox->set_active (mcs->key_get<int>(domain,key));
	    cbox->signal_changed().connect
        (sigc::bind (sigc::mem_fun(this, &::Mcs::Bind::cbox_changed_cb), cbox, domain, key));
	}
} // Mcs
