// Neon++ Library, (C) 2006 M. Derezynski
// A C++ wrapper library for neon <http://www.webdav.org/neon>, (C) Joe Orton

#include <string>
#include <ne_session.h>

#include "session.hh" 

namespace Neon
{
  Session::~Session ()
  {
    ne_session_destroy (session);
  }

  Session::Session (std::string const& hostname, std::string const& scheme, unsigned int port) throw (SessionCreateError)
    : session (0)
  {
    session = ne_session_create (scheme.c_str(), hostname.c_str(), port);
    if (!session)
      throw SessionCreateError ("Unable to create session");
    ne_set_status (session, _ne_status_notify, this);
  }

  void
  Session::_ne_status_notify (void * data, ne_conn_status status, const char * info)
  {
    Neon::Session *sess = reinterpret_cast<Neon::Session *>(data);
    sess->status_notify_.emit (status, (info && strlen(info)) ? std::string(info) : std::string());
  }

  void
  Session::close ()
  {
    ne_close_connection (session);
  }

  void
  Session::set_proxy (std::string const& hostname, unsigned int port)
  {
    ne_session_proxy (session, hostname.c_str(), port);
  }

  void
  Session::set_read_timeout (int timeout) throw (InvalidTimeoutError)
  {
    if (timeout < 0)
      throw InvalidTimeoutError("Invalid Timeout Specified. Must be > 0");
    ne_set_read_timeout (session, timeout);
  }

  std::string
  Session::get_error ()
  {
    return std::string(ne_get_error (session));
  }
}
