//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_VIDEO_WINDOW_HH
#define BMP_VIDEO_WINDOW_HH

#include <gtkmm.h>
#include <gdkmm.h>
#include <gdk/gdk.h>
#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>

namespace Bmp
{
  class VideoWidget : public Gtk::Widget
  {
    public:

        VideoWidget ();
        void set_xoverlay (GstElement *element);
        void unset_xoverlay ();

    protected:

        virtual bool on_expose_event (GdkEventExpose *event);
        virtual void on_realize ();
        virtual void on_map ();
        virtual bool on_configure_event (GdkEventConfigure *event);

    private:

        GstXOverlay *xoverlay;
        Glib::Mutex lock;
        Glib::RefPtr<Gdk::Window> video;
  };
} //

#endif // !BMP_VIDEO_WINDOW_HH
