<?xml version="1.0" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"> 

  <xsl:import href="/usr/share/sgml/docbook/stylesheet/xsl/nwalsh/xhtml/chunk.xsl"/>

  <!-- CSS Stylesheet -->
  <xsl:param name="html.stylesheet" select="'style.css'"/>

  <!-- Favicon -->
  <xsl:template name="user.head.content">
    <link xmlns="http://www.w3.org/1999/xhtml" rel="shortcut icon" href="../images/favicon.ico" type="image/ico" />
  </xsl:template>

  <!-- Custom Header -->
  <xsl:template name="user.header.navigation">
    <xsl:variable name="header" select="document('xsl/header.html',/)"/>
    <xsl:copy-of select="$header/*"/>
  </xsl:template>

  <!-- Disable header navigation  -->
  <xsl:param name="suppress.header.navigation">1</xsl:param> 

  <!-- Number sections -->
  <xsl:param name="section.autolabel">1</xsl:param> 
  <xsl:param name="section.label.includes.component.label">1</xsl:param> 

  <!-- Set icons for important notes and tips -->
  <xsl:param name="admon.graphics" select="1"/>
  <xsl:param name="admon.graphics.path" select="'../images/'" />
  <xsl:param name="admon.graphics.extension" select="'.png'"/>

  <!-- Generate links from glossterm to glossentry automaticaly -->
  <xsl:param name="glossterm.auto.link" select="1"></xsl:param>

  <!-- Make funcsynopsis look pretty -->
  <xsl:param name="funcsynopsis.decoration" select="1"/>

  <!-- Equivalent to chunk-skip-first-element-list - forces TOC on separate page
       If 0, first sect is on page for chapter or article -->
  <xsl:param name="chunk.first.sections" select="'1'"/>

  <!-- Spend extra CPU time to try and produce valid and pretty HTML -->
  <xsl:param name="html.cleanup" select="1" />
  <xsl:param name="make.valid.html" select="1" />
  <xsl:param name="chunker.output.indent" select="'yes'"/>
  <xsl:param name="chunker.output.doctype-public" select="'-//W3C//DTD XHTML 1.0 Transitional//EN'"/>
  <xsl:param name="chunker.output.doctype-system" select="'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'"/>
</xsl:stylesheet>
