#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <taglib/fileref.h>
#include <glibmm.h>

// Plugin-specific include
#include <taglib/taglib.h>
#include <taglib/fileref.h>
#include <taglib/tfile.h>
#include <taglib/tag.h>

#include <taglib/oggfile.h>
#include <taglib/vorbisfile.h>
#include <taglib/vorbisproperties.h>
#include <taglib/xiphcomment.h>

#include <boost/format.hpp>

static boost::format fsizefmt ("%llu");

extern "C" int  _plugin_has_accessors;
int  _plugin_has_accessors = 1;

#include "bmp/database-types.hh"
#include "bmp/library-types.hh"
#include "bmp/library-ops.hh"

#include "src/util-string.hh"

using namespace Glib;
using namespace TagLib;
using namespace Bmp;

extern "C" const char ** _mimetypes ()
{
  static const char * _types[] =
  {
    "application/ogg",
    NULL
  };

  return _types;
}

using namespace TagLib;

extern "C" bool _set (std::string const& name, Track & track)
{
  Ogg::Vorbis::File opfile (name.c_str());

  if (!(opfile.isOpen() && opfile.isValid()))
    return false;

  metadata_set_common (track, opfile.tag());
  Ogg::XiphComment * comment = opfile.tag();

  if (comment)
  {
    if (track.mb_album_artist)
      comment->addField (String ("MUSICBRAINZ_ALBUMARTIST",             String::UTF8),
                         String (track.mb_album_artist.get(),           String::UTF8));

    if (track.mb_album_artist_id)
      comment->addField (String ("MUSICBRAINZ_ALBUMARTISTID",           String::UTF8),
                         String (track.mb_album_artist_id.get(),        String::UTF8));

    if (track.mb_album_artist_sort_name)
      comment->addField (String ("MUSICBRAINZ_ALBUMARTISTSORTNAME",     String::UTF8),
                         String (track.mb_album_artist_sort_name.get(), String::UTF8));

    if (track.mb_track_id)
      comment->addField (String ("MUSICBRAINZ_TRACKID",                 String::UTF8),
                         String (track.mb_track_id.get(),               String::UTF8));

    if (track.mb_album_id)
      comment->addField (String ("MUSICBRAINZ_ALBUMID",                 String::UTF8),
                         String(track.mb_album_id.get(),                String::UTF8));

    if (track.mb_artist_id)
      comment->addField (String ("MUSICBRAINZ_ARTISTID",                String::UTF8),
                         String (track.mb_artist_id.get(),              String::UTF8));

    if (track.mb_artist_sort_name)
      comment->addField (String ("MUSICBRAINZ_SORTNAME",                String::UTF8),
                         String (track.mb_artist_sort_name.get(),        String::UTF8));

    if (track.mb_release_date)
      comment->addField (String ("DATE", String::UTF8),
                         String (track.mb_release_date.get(), String::UTF8));

    if (track.asin)
      comment->addField (String ("AMAZON_ASIN",    String::UTF8),
                         String (track.asin.get(), String::UTF8));

    if (track.puid)
      comment->addField (String ("MUSICIP_PUID",   String::UTF8),
                         String (track.puid.get(), String::UTF8));


    opfile.save ();
    comment = opfile.tag ();

    struct stat tagstat;
    stat (name.c_str(), &tagstat);

    TagLib::ByteVector tagData (comment->render());

    std::string size_str = (fsizefmt % (unsigned long long int) (tagstat.st_size)).str ();

    track.hash = Util::md5_hex_string (tagData.data (), tagData.size()) + size_str;
    return true;
  }
  else
  {
    return false;
  }
}

extern "C" bool _get (TagLib::File * p, DB::Row & row, std::string const& name)
{
  struct {
      AttributeId         datum;
      const std::string   id;
  } mb_metadata_xiph[] = {
    { ATTRIBUTE_MB_ALBUM_ARTIST,                "MUSICBRAINZ_ALBUMARTIST"           },
    { ATTRIBUTE_MB_ALBUM_ARTIST_ID,             "MUSICBRAINZ_ALBUMARTISTID"         },
    { ATTRIBUTE_MB_ALBUM_ARTIST_SORTNAME,       "MUSICBRAINZ_ALBUMARTISTSORTNAME"   },
    { ATTRIBUTE_MB_TRACK_ID,                    "MUSICBRAINZ_TRACKID"               },
    { ATTRIBUTE_MB_ALBUM_ID,                    "MUSICBRAINZ_ALBUMID"               },
    { ATTRIBUTE_MB_ARTIST_ID,                   "MUSICBRAINZ_ARTISTID"              },
    { ATTRIBUTE_MB_ARTIST_SORTNAME,             "MUSICBRAINZ_SORTNAME"              },
    { ATTRIBUTE_MB_RELEASE_DATE,                "DATE"                              },
    { ATTRIBUTE_ASIN,                           "AMAZON_ASIN"                       },
    { ATTRIBUTE_MUSICIP_PUID,                   "MUSICIP_PUID"                      },
  };

  Ogg::Vorbis::File * file = 0;
  if (!(file = dynamic_cast<Ogg::Vorbis::File*> (p)))
    return false;

  Ogg::XiphComment * comment = file->tag();
  if (comment)
  {
    Ogg::FieldListMap const& map (comment->fieldListMap());
    for (unsigned int n = 0; n < G_N_ELEMENTS (mb_metadata_xiph); ++n)
    {
      Ogg::FieldListMap::ConstIterator iter = map.find (TagLib::String (mb_metadata_xiph[n].id, String::UTF8));
      if (iter != map.end())
      {
        TagLib::StringList const& list (iter->second);
        row.insert (std::make_pair (get_attribute_info(mb_metadata_xiph[n].datum).id, ustring (locale_to_utf8 (list[0].to8Bit(true)))));
      }
    }
  }
  else
  {
    return false;
  }

  struct stat tagstat;
  stat(name.c_str(), &tagstat);

  TagLib::ByteVector tagData (comment->render());

  std::string hash = Util::md5_hex_string (tagData.data (), tagData.size ());
  hash += (fsizefmt % (unsigned long long int)(tagstat.st_size)).str();

  row.insert (std::make_pair (get_attribute_info(ATTRIBUTE_HASH).id, ustring (hash)));
  return true;
}
