#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>

#include <taglib/fileref.h>
// Plugin-specific include
#include "resolver.h"
#include "wmafile.h"
#include "wmatag.h"

static void _plugin_init (void) __attribute__((constructor));

static void _plugin_init (void)
{
  TagLib::FileRef::addFileTypeResolver(new WMAFileTypeResolver);
}

extern "C" int  _plugin_has_accessors;
int  _plugin_has_accessors = 1;

#include "bmp/database-types.hh"
#include "bmp/library-types.hh"
#include "bmp/library-ops.hh"

extern "C" const char ** _mimetypes ()
{
  static const char * _types[] =
  {
    "video/x-ms-asf",
    NULL
  };

  return _types;
}

using namespace TagLib;
using namespace Bmp;

extern "C" bool _set (std::string const& filename, Track & track)
{

  TagLib::WMA::File wmafile (filename.c_str());

  if (!wmafile.isOpen() && wmafile.isValid())
    return false;

  TagLib::WMA::Tag * tag = wmafile.WMATag();

  if (tag)
    {
      metadata_set_common (track, tag);      

      if (track.mb_track_id)
        tag->setAttribute("MusicBrainz/TrackId",
                           TagLib::String(track.mb_track_id.get().c_str(),
                           TagLib::String::UTF8));

      if (track.mb_artist_id)
        tag->setAttribute("MusicBrainz/ArtistId",
                           TagLib::String(track.mb_artist_id.get().c_str(),
                           TagLib::String::UTF8));

      if (track.mb_artist_sort_name)
        tag->setAttribute("MusicBrainz/SortName",
                           TagLib::String(track.mb_artist_sort_name.get().c_str(),
                           TagLib::String::UTF8));

      if (track.mb_album_id)
        tag->setAttribute("MusicBrainz/AlbumId",
                           TagLib::String(track.mb_album_id.get().c_str(),
                           TagLib::String::UTF8));

      if (track.mb_album_artist_id)
        tag->setAttribute("MusicBrainz/AlbumArtistId",
                           TagLib::String(track.mb_album_artist_id.get().c_str(),
                           TagLib::String::UTF8));

      if (track.mb_album_artist_sort_name)
        tag->setAttribute("MusicBrainz/AlbumArtistSortName",
                           TagLib::String(track.mb_album_artist_sort_name.get().c_str(),
                           TagLib::String::UTF8));

      if (track.mb_release_date)
        tag->setAttribute("MusicBrainz/AlbumReleaseDate",
                           TagLib::String(track.mb_release_date.get().c_str(),
                           TagLib::String::UTF8));

      if (track.asin)
        tag->setAttribute("Amazon/ASIN",
                           TagLib::String(track.asin.get().c_str(),
                           TagLib::String::UTF8));

      if (track.puid)
        tag->setAttribute("MusicIP/PUID",
                           TagLib::String(track.puid.get().c_str(),
                           TagLib::String::UTF8));

      wmafile.save();
      return true;
    }
  else
    {
      return false;
    }
}

extern "C" bool _get (TagLib::File * p, DB::Row & row)  
{
  WMA::File * file;

  if (!(file = dynamic_cast<WMA::File*> (p)))
    return false;

  WMA::Tag * tag = file->WMATag ();

  if (!tag)
    return false;

  const TagLib::WMA::AttributeMap &attrMap = tag->attributeMap();

  struct { 
      AttributeId     datum;
      char          * id;
  } mb_metadata_wma[] = {
      { ATTRIBUTE_MB_TRACK_ID,                "MusicBrainz/TrackId"             },
      { ATTRIBUTE_MB_ARTIST_ID,               "MusicBrainz/ArtistId"            },
      { ATTRIBUTE_MB_ALBUM_ID,                "MusicBrainz/AlbumId"             },
      { ATTRIBUTE_MB_ALBUM_ARTIST,            "MusicBrainz/AlbumArtist"         },
      { ATTRIBUTE_MB_ALBUM_ARTIST_ID,         "MusicBrainz/AlbumArtistId"       },
      { ATTRIBUTE_MB_ALBUM_ARTIST_SORTNAME,   "MusicBrainz/AlbumArtistSortName" },
      { ATTRIBUTE_MB_RELEASE_DATE,            "MusicBrainz/AlbumReleaseDate"    },
      { ATTRIBUTE_MB_ARTIST_SORTNAME,         "MusicBrainz/SortName"            },
      { ATTRIBUTE_ASIN,                       "Amazon/ASIN"                     },
      { ATTRIBUTE_MUSICIP_PUID,               "MusicIP/PUID"                    },
  };

  for (unsigned int n = 0; n < G_N_ELEMENTS (mb_metadata_wma); ++n)
    {
      if (attrMap.contains(mb_metadata_wma[n].id))
        {
          row.insert (std::make_pair (get_attribute_info(mb_metadata_wma[n].datum).id, 
            Glib::ustring (attrMap[mb_metadata_wma[n].id]->toString().toCString(true))));
        }
    }

  return true;
}
