// (c) 2005 Martin Aumueller <aumuell@reserv.at>
// See COPYING file for licensing information

#include "resolver.h"
#include "wmafile.h"

#include "src/audio/audio-typefind.hh"

TagLib::File *WMAFileTypeResolver::createFile (const char                        *filename,
                                               bool                               read_properties,
                                               TagLib::AudioProperties::ReadStyle properties_style) const 
{
    std::string type;

    if (!Bmp::Audio::typefind (filename, type))
      return 0;

    if (type == "video/x-ms-asf")
    {
      TagLib::WMA::File * p = new TagLib::WMA::File(filename, read_properties, properties_style);

      if (p->isValid())
          return p;
      else
          delete p;
    }

    return 0;
}
