//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LAST_FM_TAG_HH
#define BMP_LAST_FM_TAG_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm/markup.h>
#include <glibmm/ustring.h>
#include <gtkmm.h>
#include <libglademm.h>

#include "bmp/base-types.hh"
#include "bmp/library-types.hh"

#include "lastfm-types.hh"
#include "xspf-types.hh"

#include "lastfm.hh"

using namespace Glib;

namespace Bmp
{
  namespace LastFM
  {
    class TagDialog
      : public Gtk::Dialog
    {
      public:

        TagDialog (BaseObjectType*                  obj,
                   RefPtr<Gnome::Glade::Xml> const& xml);
        static TagDialog* create ();
        virtual ~TagDialog ();

        void run (XSPF::Item const& item);

      private:

        Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

        class CR
          : public Gtk::TreeModel::ColumnRecord
        {
          public:
            Gtk::TreeModelColumn<ustring> name;
            CR ()
            {
              add (name);
            }
        };
        CR cr; 

        Glib::RefPtr<Gtk::ListStore>        tag_store;
        Gtk::TreeView                     * tag_view;

        Gtk::Entry                        * e_artist, * e_album, * e_title;
        Gtk::Label                        * l_artist, * l_album, * l_title;

        Gtk::ComboBox                     * m_tag_cbox;
        Gtk::Entry                        * m_tag_name;

        Gtk::Image                        * m_cover;

        Gtk::Notebook                     * notebook;

        XSPF::Item                          m_item;

        bool                                m_selection_clear_block;

        void  on_tag_selected ();
        void  on_tag_cbox_changed ();
        void  on_tag_name_modified ();

        void  update_view ();
        void  tag ();

        int sort_func (Gtk::TreeIter const& i1,
                       Gtk::TreeIter const& i2);
    };
  } // namespace LastFM
} // namespace Bmp

#endif // !BMP_LAST_FM_TAG_DIALOG_HH

