//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_MINISOUP_HH
#define BMP_MINISOUP_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H
#include <glib.h>
#include <glibmm.h>
#include <iostream>
#include <fstream>

#ifndef LIBSOUP_HAS_EXTERN_C
G_BEGIN_DECLS
# include <libsoup/soup.h>
G_END_DECLS
#else
# include <libsoup/soup.h>
#endif // !LIBSOUP_HAS_EXTERN_C

namespace Bmp
{
  namespace Soup
  {
    typedef sigc::signal<void, char const* /* data */, guint /* size */, guint /* HTTP status code */> RequestCallback;
    typedef sigc::slot<void, char const* /* data */, guint /* size */, guint /* HTTP status code */> RequestSlot;

    typedef sigc::signal<void, double>              FileProgress;
    typedef sigc::signal<void, std::string const&>  FileDone;
    typedef sigc::signal<void>                      FileAborted;


    class RequestSync;
    typedef Glib::RefPtr<RequestSync> RequestSyncRefP;

    class Request;
    typedef Glib::RefPtr<Request> RequestRefP;

    class RequestFile;
    typedef Glib::RefPtr<RequestFile> RequestFileRefP;


    class RequestSync
      : public Glib::Object
    {
        FileProgress s_progress_;

      public:

        static RequestSyncRefP create (std::string const& url, bool post = false);
        ~RequestSync ();

        void  add_header (std::string const& name,
                          std::string const& value); 

        void  add_request (std::string const& type,
                           std::string const& request);

        guint run ();
        std::string get_data ();
        void get_data (std::string & data);

        char const*
        get_data_raw ();
      
        guint
        get_data_size ();

        FileProgress & progress () { return s_progress_; }

      private:

        RequestSync (std::string const& url, bool post = false);

        std::string m_url;
        bool m_post;

        std::streamsize m_size;
        std::streamsize m_read;

        SoupSession * m_session;
        SoupMessage * m_message;

        static void
        got_chunk (SoupMessage* /*message*/, gpointer /*data*/);

        static void
        got_content_length (SoupMessage* /*message*/, gpointer /*data*/);
    };


    class Request
      : public Glib::Object
    {
        RequestCallback request_callback_;

      public:

        static RequestRefP create (std::string const& url, bool post = false);
        ~Request ();

        void  add_header (std::string const& name,
                          std::string const& value); 

        void  add_request (std::string const& type,
                          std::string const& request);

        void  run ();

        void  cancel ();

        RequestCallback & request_callback() { return request_callback_; }

      private:

        Request (std::string const& url, bool post = false);

        bool        m_post;
        bool        m_block_done;
        std::string m_url;

        SoupSession * m_session;
        SoupMessage * m_message;

        static void
        got_answer (SoupMessage* message, gpointer _data);
    };


    class RequestFile
      : public Glib::Object
    {
        FileProgress s_progress_;
        FileDone s_done_;
        FileAborted s_aborted_;

      public:

        static RequestFileRefP create (std::string const& url, std::string const& filename); // XXX: Use Bmp::FileIO object instead
        ~RequestFile ();

        void  add_header (std::string const& name,
                          std::string const& value); 
        void  run ();

        void  cancel ();

        FileProgress & file_progress () { return s_progress_; }
        FileDone & file_done () { return s_done_; }
        FileAborted & file_aborted () { return s_aborted_; }

      private:

        RequestFile (std::string const& url, std::string const& filename); 

        std::ofstream m_file; 
        std::streamsize m_size;
        std::streamsize m_read;

        std::string m_url;
        std::string m_filename;

        bool  m_block_done;

        SoupSession * m_session;
        SoupMessage * m_message;

        static void
        got_answer (SoupMessage* /*message*/, gpointer /*data*/);
                   
        static void
        got_chunk (SoupMessage* /*message*/, gpointer /*data*/);

        static void
        got_content_length (SoupMessage* /*message*/, gpointer /*data*/);
    };
  };
}

#endif //!BMP_MINISOUP_HH
