//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>

#include "mb-libxml2-sax-release.hh"

using namespace Glib;
using namespace std;
using namespace Bmp::MusicBrainzXml;

namespace
{
  enum ElementId
  {
    E_RELEASE_LIST,
    E_RELEASE,
    E_TITLE,
    E_ARTIST,
    E_NAME,
    E_SORT_NAME,
    E_TRACK_LIST,
    E_TRACK,
    E_DURATION,
  };
}

#include "parser/libxml2-sax-base.hh"
using Bmp::XPath;

namespace
{
  Element_tag elements[] =
  {
    { "release-list" },
    { "release" },
    { "title" },
    { "artist" },
    { "name" },
    { "sort-name" },
    { "track-list" },
    { "track" },
    { "duration" },
  };

  struct MbTracksParseContext : public ParseContextBase
  {
    MusicBrainzTracklistTrackV &  mTrackV;

    MbTracksParseContext (MusicBrainzTracklistTrackV & v) : ParseContextBase(), mTrackV (v)  {}
  };

#define DEFAULT_REFS \
  MbTracksParseContext & context (static_cast<MbTracksParseContext&>(_context)); \
  MusicBrainzTracklistTrack & t (*context.mTrackV.rbegin()); \
  MusicBrainzReleaseV & rr (t.mReleaseV);

#define RELEASE \
  MusicBrainzRelease & r (*t.mReleaseV.rbegin());


  namespace Handlers
  {
    HANDLER(release)
    {
      DEFAULT_REFS
      rr.push_back(MusicBrainzRelease());

      RELEASE
      r.releaseId = props["id"];
      return;
    }

    HANDLER(artist)
    {
      DEFAULT_REFS
      t.artistId = props["id"];
    }

    HANDLER(track_list)
    {
      DEFAULT_REFS
      RELEASE

#if 0
      if (props.count ("count") != 0)
      {
        r.mTrackListCount = g_ascii_strtoull (props["count"].c_str(), NULL, 10);
        return;
      }

      if (props.count ("offset") != 0)
      {
        r.mTrackListOffset = g_ascii_strtoull (props["offset"].c_str(), NULL, 10);
        return;
      }
#endif
    }

    HANDLER(track)
    {
      static_cast<MbTracksParseContext&>(_context).mTrackV.push_back (MusicBrainzTracklistTrack());

      // NOTE we get DEFAULT_REFS only after adding the track
      DEFAULT_REFS
      t.trackId = props["id"];
    }
  }

  Handler_tag handlers[] = 
  {
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_TRACK]), 
      &Handlers::track      },
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_TRACK]) / XPath(elements[E_ARTIST]), 
      &Handlers::artist     },
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_TRACK]) / XPath(elements[E_RELEASE_LIST]) / XPath(elements[E_RELEASE]), 
      &Handlers::release    },
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_TRACK]) / XPath(elements[E_RELEASE_LIST]) / XPath(elements[E_RELEASE]) / XPath(elements[E_TRACK_LIST]), 
      &Handlers::track_list },
  };
  //---------
  
  namespace HandlersPCDATA
  {
    HANDLER_PCDATA(title)
    {
      DEFAULT_REFS
      RELEASE
  
      t.trackTitle += text;
    }

    HANDLER_PCDATA(release_title)
    {
      DEFAULT_REFS
      RELEASE
  
      r.releaseTitle += text;
    }

    HANDLER_PCDATA(duration)
    {
      DEFAULT_REFS

      t.trackDuration = uint64_t (g_ascii_strtoull (text.c_str(), NULL, 10));
    }

    HANDLER_PCDATA(name)
    {
      DEFAULT_REFS

      t.artistName += text;
    }

    HANDLER_PCDATA(sortname)
    {
      DEFAULT_REFS

      t.artistSortName += text;
    }
  }

  HandlerPCDATA_tag handlers_pcdata[] = 
  {
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_TRACK]) / XPath(elements[E_TITLE]), 
      &HandlersPCDATA::title         },
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_TRACK]) / XPath(elements[E_DURATION]), 
      &HandlersPCDATA::duration      },
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_TRACK]) / XPath(elements[E_ARTIST]) / XPath(elements[E_NAME]), 
      &HandlersPCDATA::name          },
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_TRACK]) / XPath(elements[E_ARTIST]) / XPath(elements[E_SORT_NAME]), 
      &HandlersPCDATA::sortname      },
    { XPath(elements[E_TRACK_LIST]) / XPath(elements[E_RELEASE_LIST]) / XPath(elements[E_RELEASE]) / XPath(elements[E_TRACK]) / XPath(elements[E_TITLE]), 
      &HandlersPCDATA::release_title },
  };
  //---------

}

namespace Bmp
{
  namespace MusicBrainzXml
  {
    int mb_xml_tracks_parse (std::string const &data, MusicBrainzTracklistTrackV & tracks)
    {
      MbTracksParseContext context (tracks); 
    
      for (unsigned int n = 0; n < G_N_ELEMENTS(handlers); ++n)
       {
         context.mHandlers.insert (std::make_pair (handlers[n].elementId, handlers[n].handler));
       }
       
       /*
       // handler/end 
       for (unsigned int n = 0; n < G_N_ELEMENTS(handlers_end); ++n)
       {
         context.mHandlersEnd.insert (std::make_pair (handlers_end[n].elementId, handlers_end[n].handler));
       }
       */
       
       // handler/pcdata
       for (unsigned int n = 0; n < G_N_ELEMENTS(handlers_pcdata); ++n)
       {
         context.mHandlersPCDATA.insert (std::make_pair (handlers_pcdata[n].elementId, handlers_pcdata[n].handler));
       }
       
       // name <-> id map 
       for (unsigned int n = 0; n < G_N_ELEMENTS(elements); ++n)
       {
         context.mNameIdMap.insert (std::make_pair (elements[n], ElementId (n)));
       }
       
       return SaxParserBase::xml_base_parse (data, context);
    }
  }
}
