//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <boost/format.hpp>
#include <boost/algorithm/string.hpp>

#include <glib/gstdio.h>
#include <glibmm.h>
#include <glibmm/i18n.h>
#include <glibmm/markup.h>
#include <iostream>
#include <fstream>

#include "main.hh"
#include "paths.hh"
#include "util.hh"
#include "uri++.hh"

#include "podcast-types.hh"

namespace Bmp
{
  namespace PodcastBackend
  {
    std::string
    cast_filename (Bmp::PodcastBackend::Podcast const& cast)
    {
      return (build_filename (BMP_PATH_PODCAST_CACHE_DIR, cast.cast_uuid));
    }

    std::string
    cast_image_filename (Bmp::PodcastBackend::Podcast const& cast)
    {
      return cast_filename (cast) + ".png";
    }
   
    std::string
    cast_overlay_filename (Bmp::PodcastBackend::Podcast const& cast)
    {
      return cast_filename (cast) + ".overlay";
    }

    std::string
    cast_item_path (Podcast const& cast)
    {
      using namespace boost::algorithm;
      using namespace Bmp; 

      std::string title = filename_from_utf8 (cast.title);
      return build_filename (mcs->key_get<std::string>("podcasts","download-dir"), title);
    }

    std::string
    cast_item_file (Podcast const& cast, PodcastItem const& item)
    {
      using namespace boost::algorithm;
      using namespace Bmp; 

      Bmp::URI u (item.enclosure_url);
      StrV subs;
      split (subs, u.path, is_any_of ("."));

      std::string type        = subs[subs.size()-1];
      std::string title       = filename_from_utf8 (cast.title);
      std::string path        = build_filename (mcs->key_get<std::string>("podcasts","download-dir"), title);
      std::string encl_base   = path_get_basename (u.path);

      // Replace forward slashes in the item title so they're not treated as path separators.
      replace_all (encl_base, "/", "-");

      std::string filename = build_filename (path, filename_from_utf8 (encl_base));
      filename += "." + type;

      return filename;
    }
  }
}
