//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_PODCAST_BACKEND_HH 
#define BMP_PODCAST_BACKEND_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <vector>

#include <boost/format.hpp>
#include <boost/optional.hpp>
#include <glibmm.h>
#include <glibmm/markup.h>

#include "util.hh"

#include "podcast-types.hh"

namespace Bmp
{
  namespace PodcastBackend
  {
    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    class PodcastOverlayParser
      : public Glib::Markup::Parser
    {
      public:

        PodcastOverlayParser (PodcastOverlayParseContext & context); 
        virtual ~PodcastOverlayParser ();

        bool check_sanity ();

      protected:

        virtual void
        on_start_element  (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname,
                           AttributeMap const& attributes);
        virtual void
        on_end_element    (Glib::Markup::ParseContext& context,
                           Glib::ustring const& elementname);
        virtual void
        on_text	          (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
        virtual void
        on_passtrough     (Glib::Markup::ParseContext& context,
                           Glib::ustring const& text);
        virtual void
        on_error	        (Glib::Markup::ParseContext& context,
                           Glib::MarkupError const& error);
      private:

        PodcastOverlayParseContext & m_context;

        enum Element
        {
          E_NONE	              = 0, 
          E_BMP_CAST_OVERLAY    = 1 << 0,
          E_CAST_ITEM           = 1 << 1,
        };

        int m_state;
    };

    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    class PodcastManager;
    class OPMLParser
      : public Glib::Markup::Parser
    {
      public:

        OPMLParser (PodcastMap & casts, PodcastManager & manager); 
        virtual ~OPMLParser ();

        bool check_sanity ();

      protected:

        virtual void
        on_start_element  (Glib::Markup::ParseContext & context,
                           Glib::ustring const& elementname,
                           AttributeMap const& attributes);
        virtual void
        on_end_element    (Glib::Markup::ParseContext & context,
                           Glib::ustring const& elementname);
        virtual void
        on_text	          (Glib::Markup::ParseContext & context,
                           Glib::ustring const& text);
        virtual void
        on_passtrough     (Glib::Markup::ParseContext & context,
                           Glib::ustring const& text);
        virtual void
        on_error	        (Glib::Markup::ParseContext & context,
                           Glib::MarkupError const& error);
      private:

        PodcastMap            & m_casts;
        PodcastManager        & m_manager;

        enum Element
        {
          E_NONE	              = 0, 
          E_OPML                = 1 << 0,
          E_HEAD                = 1 << 1,
          E_BODY                = 1 << 2,
          E_OUTLINE             = 1 << 3
        };

        int m_state;
    };

    //////////////////////////////////////////////////////////////////////////////////////////////////////////

    class PodcastManager
    {
      public:

        PodcastManager ();
        ~PodcastManager ();

        void
        save_opml             (std::string const& filename);

        void
        podcast_get_list      (PodcastList        & list);

        const Podcast&
        podcast_fetch         (Glib::ustring const& uri) const;

        void  
        podcast_cache         (Glib::ustring const& uri,
                               std::string   const& uuid = std::string());

        void
        podcast_delete        (Glib::ustring const& uri);

        void
        podcast_update        (Glib::ustring const& uri);

        void
        podcast_item_change   (Glib::ustring const& uri,
                               Glib::ustring const& uid,
                               PodcastItem   const& item_overlay);

        void
        podcast_overlay_save  (Podcast const& cast);

      private:

        friend class OPMLParser;

        void podcast_load (Podcast & cast);
        void save_overlays ();
        void save_state ();

        PodcastMap m_casts;
    };

#include "exception.hh"
    EXCEPTION(NetworkError)
    EXCEPTION(ParsingError)
    EXCEPTION(InvalidUriError)
    EXCEPTION(PodcastExistsError)
    EXCEPTION(InvalidPodcastListError)
    EXCEPTION(PodcastNotLoadedError)
    EXCEPTION(PodcastInvalidError)

  }
}
#endif
