//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_PART_RADIO_STREAMS_HH
#define BMP_UI_PART_RADIO_STREAMS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <string>
#include <sigc++/connection.h>
#include <boost/optional.hpp>

#include <glibmm/ustring.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeview.h>
#include <gtkmm/uimanager.h>
#include <libglademm/xml.h>

#include "widgets/ccwidgets.hh"

#include "ui-part-base.hh"
#include "playbacksource.hh"
#include "bookmark-handler.hh"

#include "streams-shoutcast.hh"
#include "streams-icecast.hh"

using namespace Glib;

namespace Bmp
{
  namespace UiPart
  {
    class Radio
      : public PlaybackSource,
        public Base,
        public BookmarkHandler
    {
      public:

        Radio (RefPtr<Gnome::Glade::Xml>  const& xml,
               RefPtr<Gtk::UIManager>     const& ui_manager);
        virtual ~Radio () {}

      private:

        Gtk::Notebook               * m_notebook_radio;
        Gtk::Notebook               * m_notebook_shoutcast;
        Gtk::Notebook               * m_notebook_icecast;

        Streams::Shoutcast::Streams * m_shoutcast;
        Streams::Shoutcast::Genres  * m_shoutcast_g;
        Streams::Icecast            * m_icecast;

        Sexy::IconEntry             * m_filter_entry;
        ustring                       m_current_uri;
        ustring                       m_current_name;

        void
        on_filter_changed ();

        void
        on_shoutcast_selection_changed ();

        void
        on_shoutcast_list_updated (Streams::StreamList const& list);

        void
        on_icecast_selection_changed ();

        void
        on_play_stream ();

        void
        on_update_list ();

        void
        on_set_notebook_page ();

        void
        on_row_activated (Gtk::TreePath const&, Gtk::TreeViewColumn*);

      protected:

        // PlaybackSource 
        virtual unsigned int
        add_ui ();

        virtual ustring
        get_uri ();

        virtual ustring
        get_type ()
        {
          return ustring();
        }

        virtual bool
        go_next ();

        virtual bool
        go_prev ();

        virtual void
        stop ();

        virtual void
        play ();

        virtual void
        play_post ();

        virtual void
        restore_context ();

        // BookmarkHandler
        virtual bool 
        get_bookmark (ustring const& id, /* the id to be used as the hostname part, but otherwise ignored */
                      ustring & url,
                      ustring & title);
    
        virtual bool 
        set_bookmark (ustring const& url);
    };
  }
}
#endif // !BMP_UI_PART_RADIO_STREAMS
