{-
    BNF Converter: Abstract syntax
    Copyright (C) 2004  Author: BNF Converter

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}


module AbsBNF where

-- Haskell module generated by the BNF converter

newtype Ident = Ident String deriving (Eq,Ord,Show)
data Grammar =
   Grammar [Def]
  deriving (Eq,Ord,Show)

data Def =
   Rule Label Cat [Item]
 | Comment String
 | Comments String String
 | Internal Label Cat [Item]
 | Token Ident Reg
 | Entryp [Ident]
 | Separator MinimumSize Cat String
 | Terminator MinimumSize Cat String
 | Coercions Ident Integer
 | Rules Ident [RHS]
 | Layout [String]
 | LayoutStop [String]
 | LayoutTop
  deriving (Eq,Ord,Show)

data Item =
   Terminal String
 | NTerminal Cat
  deriving (Eq,Ord,Show)

data Cat =
   ListCat Cat
 | IdCat Ident
  deriving (Eq,Ord,Show)

data Label =
   Id Ident
 | Wild
 | ListE
 | ListCons
 | ListOne
  deriving (Eq,Ord,Show)

data RHS =
   RHS [Item]
  deriving (Eq,Ord,Show)

data MinimumSize =
   MNonempty
 | MEmpty
  deriving (Eq,Ord,Show)

data Reg =
   RSeq Reg Reg
 | RAlt Reg Reg
 | RMinus Reg Reg
 | RStar Reg
 | RPlus Reg
 | ROpt Reg
 | REps
 | RChar Char
 | RAlts String
 | RSeqs String
 | RDigit
 | RLetter
 | RUpper
 | RLower
 | RAny
  deriving (Eq,Ord,Show)

