{-
    BNF Converter: Template file
    Copyright (C) 2004  Author: BNF Converter

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}


module SkelBNF where

-- Haskell module generated by the BNF converter

import AbsBNF
import ErrM
type Result = Err String

failure :: Show a => a -> Result
failure x = Bad $ "Undefined case: " ++ show x

transIdent :: Ident -> Result
transIdent x = case x of
  Ident str  -> failure x


transGrammar :: Grammar -> Result
transGrammar x = case x of
  Grammar defs  -> failure x


transDef :: Def -> Result
transDef x = case x of
  Rule label cat items  -> failure x
  Comment str  -> failure x
  Comments str0 str  -> failure x
  Internal label cat items  -> failure x
  Token id reg  -> failure x
  Entryp ids  -> failure x
  Separator minimumsize cat str  -> failure x
  Terminator minimumsize cat str  -> failure x
  Coercions id n  -> failure x
  Rules id rhss  -> failure x
  Layout strs  -> failure x
  LayoutStop strs  -> failure x
  LayoutTop  -> failure x


transItem :: Item -> Result
transItem x = case x of
  Terminal str  -> failure x
  NTerminal cat  -> failure x


transCat :: Cat -> Result
transCat x = case x of
  ListCat cat  -> failure x
  IdCat id  -> failure x


transLabel :: Label -> Result
transLabel x = case x of
  Id id  -> failure x
  Wild  -> failure x
  ListE  -> failure x
  ListCons  -> failure x
  ListOne  -> failure x


transRHS :: RHS -> Result
transRHS x = case x of
  RHS items  -> failure x


transMinimumSize :: MinimumSize -> Result
transMinimumSize x = case x of
  MNonempty  -> failure x
  MEmpty  -> failure x


transReg :: Reg -> Result
transReg x = case x of
  RSeq reg0 reg  -> failure x
  RAlt reg0 reg  -> failure x
  RMinus reg0 reg  -> failure x
  RStar reg  -> failure x
  RPlus reg  -> failure x
  ROpt reg  -> failure x
  REps  -> failure x
  RChar c  -> failure x
  RAlts str  -> failure x
  RSeqs str  -> failure x
  RDigit  -> failure x
  RLetter  -> failure x
  RUpper  -> failure x
  RLower  -> failure x
  RAny  -> failure x



