{-
    BNF Converter: Pretty-printer generator
    Copyright (C) 2004  Author:  Aarne Ranta

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module CFtoPrinter (cf2Printer) where

import CF
import Utils
import CFtoTemplate
import List (intersperse)
import Char(toLower)

-- derive pretty-printer from a BNF grammar. AR 15/2/2002

cf2Printer :: String -> CF -> String
cf2Printer name cf = unlines [
  prologue name,
  if hasIdent cf then identRule cf else "",
  unlines [ownPrintRule cf own | (own,_) <- tokenPragmas cf],
  rules cf
  ]

prologue :: String -> String
prologue name = unlines [
  "module Print" ++ name +++ "where\n",
  "-- pretty-printer generated by the BNF converter\n",
  "import Abs" ++ name,
  "import Char",
  "",
  "-- the top-level printing method",
  "printTree :: Print a => a -> String",
  "printTree = render . prt 0",
  "",
  "-- you may want to change render and parenth",
  "",
  "render :: [String] -> String",
  "render = rend 0 where",
  "  rend i ss = case ss of",
  "    \"[\"      :ts -> cons \"[\"  $ rend i ts",
  "    \"(\"      :ts -> cons \"(\"  $ rend i ts",
  "    \"{\"      :ts -> cons \"{\"  $ new (i+1) $ rend (i+1) ts",
  "    \"}\" : \";\":ts -> new (i-1) $ space \"}\" $ cons \";\" $ new (i-1) $ rend (i-1) ts",

  "    \"}\"      :ts -> new (i-1) $ cons \"}\" $ new (i-1) $ rend (i-1) ts",
  "    \";\"      :ts -> cons \";\"  $ new i $ rend i ts",
  "    t  : \",\" :ts -> cons t    $ space \",\" $ rend i ts",
  "    t  : \")\" :ts -> cons t    $ cons \")\"  $ rend i ts",
  "    t  : \"]\" :ts -> cons t    $ cons \"]\"  $ rend i ts",
  "    t        :ts -> space t   $ rend i ts",
  "    _            -> \"\"",
  "  cons s t  = s ++ t",
  "  new i s   = '\\n' : replicate (2*i) ' ' ++ dropWhile isSpace s",
  "  space t s = if null s then t else t ++ \" \" ++ s",
  "",
  "parenth :: [String] -> [String]",
  "parenth ss = [\"(\"] ++ ss ++ [\")\"]",
  "",
  "-- the printer class does the job",
  "class Print a where",
  "  prt :: Int -> a -> [String]",
  "  prtList :: [a] -> [String]",
  "  prtList = concat . map (prt 0)",
  "",
  "instance Print a => Print [a] where",
  "  prt _ = prtList",
  "",
  "instance Print Integer where",
  "  prt _ = (:[]) . show",
  "",
  "instance Print Double where",
  "  prt _ = (:[]) . show",
  "",
  "instance Print Char where",
  "  prt _ s = [\"'\" ++ mkEsc s ++ \"'\"]",
  "  prtList s = [\"\\\"\" ++ concatMap mkEsc s ++ \"\\\"\"]",
  "",
  "mkEsc s = case s of",
  "  _ | elem s \"\\\\\\\"'\" -> '\\\\':[s]", 
  "  '\\n' -> \"\\\\n\"",
  "  '\\t' -> \"\\\\t\"",
  "  _ -> [s]",


  "",
  "prPrec :: Int -> Int -> [String] -> [String]",
  "prPrec i j = if j<i then parenth else id",
  ""
  ]

identRule cf = ownPrintRule cf "Ident"

ownPrintRule cf own = unlines $ [
  "instance Print " ++ own ++ " where",
  "  prt _ (" ++ own ++ " i) = [i]",
  ifList cf own
  ]

-- copy and paste from CFtoTemplate

rules :: CF -> String
rules cf = unlines $ 
  map (\(s,xs) -> case_fun s (map toArgs xs) ++ ifList cf s) $ cf2data cf
 where 
   toArgs (cons,args) = ((cons, names (map (checkRes . var) args) (0 :: Int)), ruleOf cons)
   names [] _ = []
   names (x:xs) n
     | elem x xs = (x ++ show n) : names xs (n+1)
     | otherwise = x             : names xs n
   var ('[':xs)  = var (init xs) ++ "s"
   var "Ident"   = "id"
   var "Integer" = "n"
   var "String"  = "str"
   var "Char"    = "c"
   var "Double"  = "d"
   var xs        = map toLower xs
   checkRes s
        | elem s reservedHaskell = s ++ "'"
	| otherwise              = s
   reservedHaskell = words $ 
			 concat ["case class data default deriving do else",
				 "if import in infix infixl infixr instance",
				 "let module newtype of then type where as",
				 "qualified hiding"] 
   ruleOf s = maybe undefined id $ lookup s (rulesOfCF cf)

--- case_fun :: Cat -> [(Constructor,Rule)] -> String
case_fun cat xs = unlines [
  "instance Print" +++ cat +++ "where",
  "  prt i" +++ "e = case e of",
  unlines $ map (\ ((c,xx),r) -> 
    "   " ++ c +++ unwords xx +++ "->" +++ 
    "prPrec i" +++ show (precCat (fst r)) +++ mkRhs xx (snd r)) xs
  ]

ifList cf cat = mkListRule $ nil cat ++ one cat ++ cons cat where
  nil cat  = ["   [] -> " ++ mkRhs [] its | 
                            (f,(c,its)) <- rulesOfCF cf, isNilFun f , normCatOfList c == cat]
  one cat  = ["   [x] -> " ++ mkRhs ["x"] its | 
                            (f,(c,its)) <- rulesOfCF cf, isOneFun f , normCatOfList c == cat]
  cons cat = ["   x:xs -> " ++ mkRhs ["x","xs"] its | 
                            (f,(c,its)) <- rulesOfCF cf, isConsFun f , normCatOfList c == cat]
  mkListRule [] = ""
  mkListRule rs = unlines $ ("  prtList" +++ "es = case es of"):rs


mkRhs args its = 
  "(concat [" ++ unwords (intersperse "," (mk args its)) ++ "])"
 where
  mk (arg:args) (Left c : items)  = (prt c +++ arg)        : mk args items
  mk args       (Right s : items) = ("[" ++ show s ++ "]") : mk args items
  mk _ _ = []
  prt c = "prt" +++ show (precCat c)

