// ChannelList.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef CHANNELLIST_H
#define CHANNELLIST_H

#include <map.h>

#include "String.H"
#include "ServerConnection.H"
#include "Channel.H"

class Utils;
class UserCommands;

class ChannelList {
  map<String, Channel *, less<String> > list;
  
public:
  ChannelList();
  ~ChannelList();

  void addChannel(ServerConnection *, String, String = "");
  void delChannel(String);
  
  Channel * getChannel(String);

  void clear();

  map<String, Channel *, less<String> >::iterator begin()
    { return list.begin(); }
  map<String, Channel *, less<String> >::iterator end()
    { return list.end(); }

  friend class Utils;
  friend class UserCommands;
};

#endif
