// ShitList.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <fstream.h>

#include "ShitList.H"
#include "StringTokenizer.H"

ShitList::ShitList(String filename)
  : listFileName(filename)
{
#ifdef HAVE_STL_CLEAR
  l.clear();
#endif
  read();
}

ShitList::~ShitList()
{
  clear();
}

void
ShitList::read()
{
  ifstream file(listFileName);
  String temp;
  int line = 1;

  clear();

  if (!file) {
    cerr << "I cannot find the file " << listFileName << endl;
    return;
  }

  while (file >> temp, temp.length() != 0) {
    StringTokenizer st(temp);
    String mask = st.nextToken(':');
    String channelMask = st.nextToken(':');
    String level = st.nextToken(':');
    String expiration = st.nextToken(':');
    String reason = st.rest().trim();
    l.push_back(new ShitEntry(mask, channelMask, atoi(level), atol(expiration), reason));
    line++;
  }
  file.close();
}

void
ShitList::save()
{
  list<ShitEntry *>::iterator it = l.begin();
  ofstream file(listFileName);

  if (!file)
    return;

  for ( ; it != l.end(); ++it)
    if ((*it)->isStillValid()) {
      file << (*it)->shitMask.getMask() << ":"
           << (*it)->shitChannelMask.getMask() << ":"
           << (*it)->shitLevel << ":"
           << (*it)->expirationDate << ":"
           << (*it)->shitReason << endl;
    }
}

void
ShitList::clear()
{
  ShitEntry *se;

  while (!l.empty()) {
    se = (*l.begin());
    l.erase(l.begin());
    delete se;
  }
}

void
ShitList::addShit(String m, String mc, int lev, time_t e, String r)
{
  l.push_back(new ShitEntry(m, mc, lev, e, r));
}


void
ShitList::delShit(String mask, String channelMask)
{
  for (list<ShitEntry *>::iterator it = l.begin();
       it != l.end();
       ++it)
    if ((*it)->shitMask.getMask() == mask &&
        (*it)->shitChannelMask.getMask() == channelMask) {
      delete (*it);
      l.erase(it);
      return;
    }
}

ShitEntry *
ShitList::getShit(String nuh, String channel)
{
  for (list<ShitEntry *>::iterator it = l.begin();
       it != l.end();
       ++it)
    if ((*it)->matches(nuh, channel)) {
      return (*it);
    }

  return 0;
}
