/* error.c -- deal with error situations
 * Written by Charles Briscoe-Smith; refer to the file LEGAL for details.
 */

/* Interface definition */

#ifdef __GNUC__
#define NORETURN __attribute__ ((__noreturn__));
#else
#define NORETURN
#endif

/* Signal an unrecoverable error and terminate the program */
extern void fatal(const char *) NORETURN ;

/* Signal an error, but carry on processing */
extern void error(const char *) NORETURN ;

/* Signal an internal compiler error */
#define thiscanthappen error_canthappen(__FILE__, __LINE__)
extern void error_canthappen(const char *, int) NORETURN ;


#ifndef SEEN_error_h

#include <stdio.h>
#include <stdlib.h>

void
error_canthappen(const char *file, int line)
{
	fprintf(stderr, "BOCK OOPS: %s: %d: This can't happen.\n", file, line);
	abort();
}

void
error(const char *msg)
{
	fprintf(stderr, "Error: %s\n", msg);
	exit(1);
}

#endif /* SEEN_error_h */
