/* bock.c -- bootstrapping compiler for a Java(tm)-like language
 * Written by Charles Briscoe-Smith; refer to the file LEGAL for details.
 */

#include <stdlib.h>
#include <stdio.h>
#include "packagetree.h"
#include "codegen.h"
#include "transform.h"

int num_errors=0;

extern int input_line;
extern void yyrestart(FILE *);
extern int yyparse();
extern const char *input_file;

struct typedecl *bock_cu;

int
main(int ac, char *av[])
{
	FILE *fp=0;
	int help=0;
	const char *name=*av;
	const char *output_name=0;
	char *start_class=0;

	for (ac--, av++; ac; ac--, av++) {
		if ((*av)[0]=='-') {
			switch ((*av)[1]) {
			case '-':
				fprintf(stderr, "%s: no long options\n", name);
				num_errors++;
				break;
			case 'o':
				if ((*av)[2]) {
					output_name=&((*av)[2]);
				} else if (*++av) {
					output_name=*av;
					ac--;
				} else {
					av--;
					num_errors++;
					fprintf(stderr,
					    "%s: output name not specified\n",
					    name);
				}
				break;
			case 's':
				if ((*av)[2]) {
					start_class=&((*av)[2]);
				} else if (*++av) {
					start_class=*av;
					ac--;
				} else {
					av--;
					num_errors++;
					fprintf(stderr,
					    "%s: start class not specified\n",
					    name);
				}
				break;
			case 'h':
				help=1;
				num_errors++;
				break;
			default:
				num_errors++;
				fprintf(stderr, "%s: unknown option `%c'\n",
					name, (*av)[1]);
			}
			continue;
		}

		fp=fopen(*av, "r");
		if (fp==0) {
			perror(*av);
			num_errors++;
			continue;
		}

		yyrestart(fp);
		input_file=*av;
		input_line=1;
		if (yyparse()) {
			num_errors++;
		}
		fclose(fp);

		if (num_errors==0) {
			packagetree_add_compunit(bock_cu);
		}
	}

	if (help==0 && start_class==0) {
		fprintf(stderr, "%s: Start class not specified; using `Test'\n", name);
		start_class="Test";
	}

	if (fp==0) {
		fprintf(stderr, "%s: No compilation units\n", name);
		num_errors++;
	}

	if (num_errors) {
		fprintf(help?stdout:stderr,
			"Usage: %s -s startclass [-o outfile] javafile...\n",
			name);
		return 1;
	}

	/* We've loaded all the source code.  Now do some munging... */
	transform();

	/* And spit out the appropriate C code... */
	if (output_name) {
		fp=fopen(output_name, "w");
		if (fp) {
			codegen(fp, start_class);
		} else {
			perror(output_name);
			num_errors++;
		}
	} else {
		codegen(stdout, start_class);
	}

	if (num_errors) {
		return 1;
	}

	return 0;
}
