/*
 * Bognor-Regis - a media player/queue daemon.
 * Copyright © 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BR_QUEUE_H__
#define __BR_QUEUE_H__

#include <glib-object.h>


G_BEGIN_DECLS

#define BR_TYPE_QUEUE                                                   \
   (br_queue_get_type())
#define BR_QUEUE(obj)                                                   \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BR_TYPE_QUEUE,                          \
                                BrQueue))
#define BR_QUEUE_CLASS(klass)                                           \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BR_TYPE_QUEUE,                             \
                             BrQueueClass))
#define IS_BR_QUEUE(obj)                                                \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BR_TYPE_QUEUE))
#define IS_BR_QUEUE_CLASS(klass)                                        \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BR_TYPE_QUEUE))
#define BR_QUEUE_GET_CLASS(obj)                                         \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BR_TYPE_QUEUE,                           \
                               BrQueueClass))

#define BR_QUEUE_DBUS_INTERFACE "org.moblin.BognorRegis.Queue"

char *br_queue_dbus_service (void);
char *br_queue_dbus_local_path (void);

typedef struct _BrQueuePrivate BrQueuePrivate;
typedef struct _BrQueue      BrQueue;
typedef struct _BrQueueClass BrQueueClass;

typedef void (*BrQueueListUrisCallback) (BrQueue *queue,
                                         char   **uris,
                                         GError  *error,
                                         gpointer userdata);
typedef void (*BrQueueGetNowPlayingCallback) (BrQueue *queue,
                                              char    *audio_uri,
                                              char    *visual_uri,
                                              GError  *error,
                                              gpointer userdata);
typedef void (*BrQueueGetNameCallback) (BrQueue *queue,
                                        char    *name,
                                        GError  *error,
                                        gpointer userdata);
typedef void (*BrQueueGetPositionCallback) (BrQueue *queue,
                                            double   position,
                                            GError  *error,
                                            gpointer userdata);
typedef void (*BrQueueGetPlayingCallback) (BrQueue *queue,
                                           gboolean playing,
                                           GError  *error,
                                           gpointer userdata);

typedef enum _BrQueueType {
    BR_QUEUE_AUDIO_TYPE,
    BR_QUEUE_VISUAL_TYPE
} BrQueueType;

struct _BrQueue
{
    GObject parent;

    BrQueuePrivate *priv;
};

struct _BrQueueClass
{
    GObjectClass parent_class;
};

GType br_queue_get_type (void) G_GNUC_CONST;

BrQueue *br_queue_new (const char *service_name,
                       const char *object_path);
BrQueue *br_queue_new_local (void);

void br_queue_play (BrQueue *queue);
void br_queue_play_uri (BrQueue    *queue,
                        const char *uri,
                        const char *mimetype);
void br_queue_stop (BrQueue *queue);
void br_queue_next (BrQueue *queue);
void br_queue_add_uri (BrQueue    *queue,
                       const char *uri,
                       const char *mimetype);
void br_queue_clear (BrQueue *queue);
void br_queue_remove (BrQueue    *queue,
                      int         index);
void br_queue_list_uris (BrQueue                *queue,
                         BrQueueListUrisCallback cb,
                         gpointer                userdata);
void br_queue_get_now_playing (BrQueue                     *queue,
                               BrQueueGetNowPlayingCallback cb,
                               gpointer                     userdata);
void br_queue_insert_uri (BrQueue    *queue,
                          const char *uri,
                          const char *mimetype,
                          int         position);
void br_queue_get_name (BrQueue               *queue,
                        BrQueueGetNameCallback cb,
                        gpointer               userdata);
void br_queue_set_position (BrQueue    *queue,
                            BrQueueType type,
                            double      position);
void br_queue_get_position (BrQueue                   *queue,
                            BrQueueType                type,
                            BrQueueGetPositionCallback cb,
                            gpointer                   userdata);
void br_queue_get_playing (BrQueue                  *queue,
                           BrQueueGetPlayingCallback cb,
                           gpointer                  userdata);

G_END_DECLS

#endif /* __BR_QUEUE_H__ */
