/*
 * Bognor-Regis - a media player/queue daemon.
 * Copyright © 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <config.h>
#include <stdio.h>

#include <glib.h>
#include <glib/gi18n.h>

#include <gst/gst.h>
#include <gtk/gtk.h>

#include <dbus/dbus-protocol.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-bindings.h>

#include "bognor-queue-manager.h"

typedef struct BognorRegis {
    DBusGConnection *connection;
    DBusGProxy *proxy; /* Do we need to keep this around? */

    BognorQueueManager *manager;
    GMainLoop *mainloop;
} BognorRegis;

BognorRegis *br;

#define BOGNOR_NAME "org.moblin.BognorRegis"
#define BOGNOR_MANAGER_PATH "/org/moblin/BognorRegis/QueueManager"

static gboolean
init_dbus (void)
{
    guint32 request_name_ret;
    GError *error = NULL;

    bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);

    br->connection = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
    if (br->connection == NULL) {
        g_warning ("Error getting bus: %s", error->message);
        g_error_free (error);

        return FALSE;
    }

    br->proxy = dbus_g_proxy_new_for_name (br->connection,
                                           DBUS_SERVICE_DBUS,
                                           DBUS_PATH_DBUS,
                                           DBUS_INTERFACE_DBUS);
    if (!org_freedesktop_DBus_request_name (br->proxy, BOGNOR_NAME,
                                            0, &request_name_ret, &error)) {
        g_warning ("Error registering on DBus: %s", error->message);
        g_error_free (error);

        return FALSE;
    }

    if (request_name_ret != DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
        return FALSE;
    }

    br->manager = bognor_queue_manager_new (br->connection);
    dbus_g_connection_register_g_object (br->connection, BOGNOR_MANAGER_PATH,
                                         G_OBJECT (br->manager));

    return TRUE;
}

int
main (int    argc,
      char **argv)
{
    g_type_init ();
    gst_init (&argc, &argv);
    gtk_init (&argc, &argv);

    br = g_new0 (BognorRegis, 1);

    if (init_dbus () == FALSE) {
        return 0;
    }

    br->mainloop = g_main_loop_new (NULL, FALSE);
    g_main_loop_run (br->mainloop);

    return 0;
}
